<?php
class Administracion extends CI_Controller{
	function __construct(){
		parent::__construct();
		$this->is_logged_in();
		$this->session_ = $this->session->userdata('userInfo');
		$this->permisos=$this->Generic_model->get('usuarios','permisos_usuario',array('id_usuario'=>$this->session_['userid']));
		$this->permisos=unserialize(base64_decode($this->permisos[0]->permisos_usuario));
		/*usuario*/
		$this->usuario=$this->Generic_model->get('usuarios','nombre_usuario as nombre,username_usuario as username, thumb_usuario as thumbnail',array('id_usuario'=>$this->session_['userid']));
		$this->usuario=$this->usuario[0];
	}
	/**/
	function index(){echo "Administracion!";}
	/*------------------------- GENERAL ----------------------*/
	function general(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']	= "Administraci&oacute;n general";
		if(!filter_var($this->permisos['administraciongeneral']['administraciongeneral-crud'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
		}else{
			$UIData['main_view']="administracion_general_view";
			$UIData['jsfiles']=array("miracle.configuraciones");
			$UIData['plugins']=array(
				array(
					"nombre"=>"jquery_form",
					"js"=> array('jquery.form.min')
				),
				array(
					"nombre"=>"input-mask",
					"js"=> array('jquery.inputmask','jquery.inputmask.date.extensions','jquery.inputmask.extensions')
				),
				array(
					"nombre"=>"datapicker",
					"css"=>array('datepicker3'),
					"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
				),
				array(
					"nombre"=>"datatables",
					"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
					"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
				),
			);
			$configuraciones = $this->Generic_model->get('configuraciones');
			$configs = array();		
			foreach($configuraciones as $config){
				$configs[$config->campo_config] = $config->valor_config;
			}
			$UIData['configs'] = $configs;
		}
		$this->load->view('template', $UIData);
	}
		function guardar_configuraciones(){
			if($this->input->post('logo_empresa') != ""){
				$imagen = $this->input->post('logo_empresa');
			}else{
				$imagen = "";
			}
			
			$conf['upload_path'] = './upload_images/';
			$conf['allowed_types'] = 'gif|jpg|png';
			$conf['file_name'] = 'img-logo'.md5(date('Y-m-d h:m:s'));
			
			$this->load->library('upload', $conf);
			$this->upload->overwrite = true;
		
			if($this->upload->do_upload('conf-gral-logo-file')){
				$uploadData = $this->upload->data();
				$imgPatch ='upload_images/'.$uploadData['orig_name'];
				
				$this->load->library('image_lib');
				
				$config['image_library'] = 'gd2';
				$config['source_image']  = $imgPatch;
				$config['maintain_ratio'] = TRUE;
				$config['height']    = 200;
				$config['width']    = 350;
				
				$this->image_lib->initialize($config);
				
				
				if($this->image_lib->resize()){
					$imagen = $imgPatch;
				}
			}else{
				$imagen = $imagen;
			}
			
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('NombreEmpresa')),'campo_config','NombreEmpresa');
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('RazonSocialEmpresa')),'campo_config','RazonSocialEmpresa');
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('DireccionEmpresa')),'campo_config','DireccionEmpresa');
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('TelefonoEmpresa')),'campo_config','TelefonoEmpresa');
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('ClasificacionEmpresa')),'campo_config','ClasificacionEmpresa');
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('NITEmpresa')),'campo_config','NITEmpresa');
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('NRCEmpresa')),'campo_config','NRCEmpresa');
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('GiroEmpresa')),'campo_config','GiroEmpresa');
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $imagen),'campo_config','LogoEmpresa');
		}
		function cargar_configs_obj(){
			$configs=$this->input->post('configs');
			$configs=json_decode($configs);
			foreach($configs as $conf => $value){
				$value=$this->Generic_model->get('configuraciones','valor_config',array('campo_config'=>$conf));
				if($value){
					$return=explode("|",$value[0]->valor_config);
					$returnMode=$return[1];
					switch($returnMode){
						case "t":/*texto plano*/
							$configs->$conf=$return[0];
						break;
						case "b":/*Boolean*/
							$configs->$conf=filter_var($return[0],FILTER_VALIDATE_BOOLEAN);
						break;
						case "a":/*array*/
							$configs->$conf=explode(",",$return[0]);
						break;
					}
				}
			}
			echo json_encode($configs);
		}
	/*------------------------- FACTURACION ----------------------*/
	function facturacion(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']	= "Administraci&oacute;n de facturaci&oacute;n";
		if(!filter_var($this->permisos['administracionfacturacion']['administracionfacturacion-ver'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
		}else{
			$UIData['main_view']="administracion_facturacion_view";
			$UIData['jsfiles']=array("miracle.cajas","miracle.administracion_facturacion_caja_resolucion_nueva.min","miracle.transacciones_cortes_app");
			$UIData['plugins']=array(
				array(
					"nombre"=>"datatables",
					"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
					"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
				),
				array(
					"nombre"=>"jquery_form",
					"js"=> array('jquery.form.min')
				),
				array(
					"nombre"=>"input-mask",
					"js"=> array('jquery.inputmask','jquery.inputmask.date.extensions','jquery.inputmask.extensions')
				),
				array(
					"nombre"=>"datapicker",
					"css"=>array('datepicker3'),
					"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
				),
			);
			$wheres = array('campo_config' => 'MensajeTicket');			
			$MensajeTicket = $this->Generic_model->get('configuraciones','*',$wheres);		
			$UIData['MensajeTicket'] = $MensajeTicket[0];
			$wheres = array('campo_config' => 'MensajeHeaderCotizacion');			
			$MensajeHeaderCotizacion = $this->Generic_model->get('configuraciones','*',$wheres);		
			$UIData['MensajeHeaderCotizacion'] = $MensajeHeaderCotizacion[0];
			$wheres = array('campo_config' => 'MensajeFooterCotizacion');			
			$MensajeFooterCotizacion = $this->Generic_model->get('configuraciones','*',$wheres);		
			$UIData['MensajeFooterCotizacion'] = $MensajeFooterCotizacion[0];
			$UIData['permisos_mensaje']=filter_var($this->permisos['administracionfacturacion']['administracionfacturacion-mensaje'],FILTER_VALIDATE_BOOLEAN);
			$UIData['permisos_cajaop']=filter_var($this->permisos['administracionfacturacion']['administracionfacturacion-cajas'],FILTER_VALIDATE_BOOLEAN);
		}
		$this->load->view('template', $UIData);
	}
		function nuevacaja(){
			$UIDataModal["title"]="Nueva caja";
			if(!filter_var($this->permisos['administracionfacturacion']['administracionfacturacion-cajas'],FILTER_VALIDATE_BOOLEAN)){
				$UIDataModal['content_view']="error_noacceso_view";
			}else{
				$UIDataModal["content_view"]="administracion_facturacion_caja_nueva_view";
				$UIDataModal["close_button"] = true;
				$UIDataModal["classes"] = "modal-lg";
				$UIDataModal["id"] = "usuarios-nuevo-modal";
				if($this->input->get('id')){
					$wheres = array('id_caja' => $this->input->get('id'));
					$caja = $this->Generic_model->get('cajas','*',$wheres);
					$UIDataModal['caja'] = $caja[0];
				}
			}
			$this->load->view('template_modal',$UIDataModal); 
		}
		function guardar_caja(){
			$data = array(
				'nombre_caja'			=> $this->input->post('nombre_caja'),
				'direccion_ip_caja'		=> $this->input->post('direccion_ip_caja'),
				'printer_receipt'				=> $this->input->post('printer_receipt'),
				'printer_journal'				=> $this->input->post('printer_journal'),
				'printer_slip'					=> $this->input->post('printer_slip')
			);
			
			if($this->input->post('id_caja') == ''){
				$idcaja = $this->Generic_model->save('cajas',$data,true);
				echo $this->input->post('nombre_caja').'‡'.$idcaja;
			}else{			
				$this->Generic_model->update('cajas',$data,'id_caja',$this->input->post('id_caja'));
				echo $this->input->post('nombre_caja').'‡'.$this->input->post('id_caja');
			}
		}
		function cargar_cajas(){
			$data["cajas"] = $this->Generic_model->get('cajas');
			$this->load->view('administracion_facturacion_cajas_view',$data); 
		}
		function detalles_caja(){
			$wheres = array('id_caja' => $this->input->get('id'));
			$caja = $this->Generic_model->get('cajas','*',$wheres);
			$data['caja'] = $caja[0];
			$data['permisos_cortes']=filter_var($this->permisos['administracionfacturacion']['administracionfacturacion-cortes'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_cajaop']=filter_var($this->permisos['administracionfacturacion']['administracionfacturacion-cajas'],FILTER_VALIDATE_BOOLEAN);
			$this->load->view('administracion_facturacion_cajas_detalles_view',$data); 
		}
		function eliminar_caja(){
			if(filter_var($this->permisos['administracionfacturacion']['administracionfacturacion-cajas'],FILTER_VALIDATE_BOOLEAN)){
				if($this->Generic_model->delete('cajas','id_caja',$this->input->get('id'))){
					echo 'Borrado';
				}
			}
		}
	
		function facturacionvercortes(){
			
			
		}
		function cargar_cortes(){
			$this->load->library("ssp");
		
			$table = 'cortes';
			$primaryKey = 'id_corte';
			
			$columns = array(
				array(
					'db' => 'id_corte',
					'dt' => 'DT_RowId',
					'formatter' => function( $d, $row ) {
						return 'row_'.$d;
					}
				),
				array( 'db' => 'id_corte', 'dt' => 'id_corte' ),
				array(
					'db' => 'fecha_corte',
					'dt' => 'fecha_corte',
					'formatter' => function($d,$row){
						$dateConvert = explode('-',$d);
						$timeConvert = explode(' ',$dateConvert[2]);
						return $timeConvert[0].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0].' a las '.$timeConvert[1];
					}
				),
				array( 'db' => 'correlativo_corte', 'dt' => 'correlativo_corte' ),
				array(
					'db' => 'tipo_corte',
					'dt' => 'tipo_corte',
					'formatter' => function( $d, $row ) {								
						switch($d):
							case "0";
									return "Corte X Inicial";
								break;
							case "1";
									return "Corte X Parcial";
								break;
							case "2";
									return "Corte Z";
								break;
							case "3";
									return "Corte Gran Z";
								break;
						endswitch;
					}
				),
				array(
					'db' => 'id_corte',
					'dt' => 'acciones',
					'formatter' => function( $d, $row ) {
						$datatarget = base_url('transacciones/vercortes?id='.$d.'&modal=true');
						
						return '<button data-target="'.$datatarget.'" class="btn btn-info btn-xs modal-trigger">Ver</button>';
					}
				),
			);
			$host =  explode(':',$this->db->hostname);
			$sql_details = array(
				'user' => $this->db->username,
				'pass' => $this->db->password,
				'db'   => $this->db->database,
				'host' => $host[0]
			);
			
			/*$joinQuery = "FROM `user` AS `u` JOIN `user_details` AS `ud` ON (`ud`.`user_id` = `u`.`id`)";
			$extraWhere = "`u`.`salary` >= 90000";*/
			$joinQuery = "";
			$extraWhere = "id_caja =".$this->input->post("idCaja");
			 
			echo json_encode(
				$this->ssp->simple($this->input->post(), $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere)
			);
		}
		function cargar_resoluciones(){
			$this->load->library("ssp");
		
			$table = 'resoluciones_caja';
			$primaryKey = 'id_resolucion';
			
			$columns = array(
				array(
					'db' => 'id_resolucion',
					'dt' => 'DT_RowId',
					'formatter' => function( $d, $row ) {
						return 'row_'.$d;
					}
				),
				array( 'db' => 'id_resolucion', 'dt' => 'id_resolucion' ),
				array(
					'db' => 'fecha_autorizacion',
					'dt' => 'fecha_autorizacion',
					'formatter' => function($d,$row){
						$dateConvert = explode('-',$d);
						return $dateConvert[2].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0];
					}
				),
				array( 'db' => 'num_resolucion', 'dt' => 'num_resolucion' ),
				array(
					'db' => 'estado_resolucion',
					'dt' => 'estado_resolucion',
					'formatter' => function( $d, $row ) {								
						switch($d):
							case "0";
									return '<span class="label label-info">Activa</span>';
								break;
							case "1";
									return '<span class="label">Agotada</span>';
								break;
						endswitch;
					}
				),
				array(
					'db' => 'id_resolucion',
					'dt' => 'acciones',
					'formatter' => function( $d, $row ) {
						//$datatarget = base_url('administracion/facturacionvercortes?id='.$d);
						
						return '<button data-target="'.$datatarget = "".'" class="btn btn-info btn-xs modal-trigger">Ver</button>';
					}
				),
			);
			$host =  explode(':',$this->db->hostname);
			$sql_details = array(
				'user' => $this->db->username,
				'pass' => $this->db->password,
				'db'   => $this->db->database,
				'host' => $host[0]
			);
			
			/*$joinQuery = "FROM `user` AS `u` JOIN `user_details` AS `ud` ON (`ud`.`user_id` = `u`.`id`)";
			$extraWhere = "`u`.`salary` >= 90000";*/
			$joinQuery = "";
			$extraWhere = "id_caja =".$this->input->post("idCaja");
			 
			echo json_encode(
				$this->ssp->simple($this->input->post(), $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere)
			);
		}
		function nueva_resolucion(){
			$UIDataModal["title"]="Nueva serie de documentos";
			$UIDataModal["content_view"]="administracion_facturacion_caja_resolucion_nueva_view";
			$UIDataModal["close_button"] = true;
			$UIDataModal["classes"] = "modal-md";
			$UIDataModal["id"] = "resolucion-nuevo-modal";
			$UIDataModal["caja"] =$this->input->get('caja');
			if($this->input->get("resolucion")){
				$resolucion=$this->Generic_model->get('resoluciones_caja','*',array('id_resolucion'=>$this->input->get("resolucion")));
				$UIDataModal["res"]=$resolucion[0];
			}
			$this->load->view('template_modal',$UIDataModal);
		}
		function guardar_resolucion(){
			$data = array(
				"id_caja"=>$this->input->post("admin_nueva_res_resolucion_caja"),
				"estado_resolucion"=>0,
				"num_resolucion"=>$this->input->post("admin_nueva_res_resolucion"),
				"num_autorizacion"=>$this->input->post("admin_nueva_res_autorizacion"),
				"fecha_autorizacion"=> date("Y-m-d", strtotime($this->input->post("admin_nueva_res_fecha"))),
				"serie_autorizada"=>$this->input->post("admin_nueva_res_serie"),
				"tiraje_desde"=>$this->input->post("admin_nueva_res_desde"),
				"tiraje_hasta"=>$this->input->post("admin_nueva_res_hasta"),
				"tiraje_actual"=>($this->input->post("admin_nueva_res_actual")!=""?$this->input->post("admin_nueva_res_actual"):'1'),
				"documento_resolucion"=>$this->input->post("admin_nueva_res_ducumento")
			);
			
			if($this->input->post('admin_nueva_res_resolucion_id') == ''){
				if($this->Generic_model->save('resoluciones_caja',$data))
					echo "guardado";
			}else{			
				if($this->Generic_model->update('resoluciones_caja',$data,'id_resolucion',$this->input->post('admin_nueva_res_resolucion_id')))
					echo "actualizado";
			}
		}
		function resolucionesxdoc(){
			$caja=$this->input->get("caja");
			$doc=$this->input->get("doc");
			
			if($this->input->get("activas")){
				echo json_encode($this->Generic_model->get("resoluciones_caja","id_resolucion as id,serie_autorizada as serie,tiraje_actual as actual",array('id_caja'=>$caja,'documento_resolucion'=>$doc,'estado_resolucion'=>0)));
			}else{
				echo json_encode($this->Generic_model->get("resoluciones_caja","id_resolucion as id,serie_autorizada as serie,tiraje_actual as actual",array('id_caja'=>$caja,'documento_resolucion'=>$doc)));
			}
		}
		function guardar_mensaje(){
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('MensajeTicket')),'campo_config','MensajeTicket');
		}
		function guardar_mensajes_cotizaciones(){
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('MensajeHeaderCotizacion')),'campo_config','MensajeHeaderCotizacion');
			$this->Generic_model->update('configuraciones',$data = array('valor_config' => $this->input->post('MensajeFooterCotizacion')),'campo_config','MensajeFooterCotizacion');
		}
	/*------------------------- USUARIOS ----------------------*/
	function usuarios(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']	= "Administraci&oacute;n de usuarios";
		$UIData['main_view']	= "administracion_usuarios_view";
		$UIData['jsfiles']=array("miracle.usuarios");	
		$UIData['plugins']=array(
			array(
				"nombre"=>"jquery_form",
				"js"=> array('jquery.form.min')
			),
			array(
				"nombre"=>"sha1",
				"js"=> array('sha1')
			),
			array(
				"nombre"=>"datapicker",
				"css"=>array('datepicker3'),
				"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
			),
			array(
				"nombre"=>"datatables",
				"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
				"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
			),
			array(
				"nombre"=>"iCheck",
				"css"=>array('custom'),
				"js"=>array('icheck.min')
			),
		);		
		$usuario = $this->Generic_model->get("usuarios","id_usuario,nombre_usuario,username_usuario,perfil_usuario,thumb_usuario",array("id_usuario" => $this->session_['userid']));
		$UIData['usuario']=$usuario[0];
		$UIData['permiso_usuariosver']=filter_var($this->permisos['administracionusuarios']['administracionusuarios-ver'],FILTER_VALIDATE_BOOLEAN);
		$this->load->view('template', $UIData);
	}
		/*cambiarcontrasena*/
		function cambiarcontrasena(){
			$UIDataModal["content_view"]="administracion_usuarios_cambiar_contrasena_view";
			$UIDataModal["title"]="Cambiar contrase&ntilde;a";
			$UIDataModal["close_button"] = true;
			$UIDataModal["classes"] = "modal-sm";
			$UIDataModal["id"] = "usuarios-cambiar-contrasena-modal";
			
			$usuario = $this->Generic_model->get("usuarios","id_usuario,password_usuario",array("id_usuario" => $this->input->get('idusuario')));
		
			$UIDataModal['usuario']=$usuario[0];
			
			$this->load->view('template_modal',$UIDataModal); 
		}
		function actualizar_password(){
			$data=array(
				'password_usuario'=>sha1($this->input->post('confirm_password'))
			);
			
			$this->Generic_model->update('usuarios',$data,'id_usuario',$this->input->post('id_usuario_change_pass'));
		}
		/*nuevo usuario*/
		function nuevousuario(){
			if($this->input->get('id')){
				$UIDataModal["title"]="Editar usuario";
				if(!filter_var($this->permisos['administracionusuarios']['administracionusuarios-editar'],FILTER_VALIDATE_BOOLEAN)){
					$UIDataModal['content_view']="error_noacceso_view";
				}else{
					$usuario=$this->Generic_model->get('usuarios','*',array('id_usuario'=>$this->input->get('id')));
					$UIDataModal['usuario']=$usuario[0];
					$UIDataModal['permisos'] = unserialize(base64_decode($usuario[0]->permisos_usuario));
					$UIDataModal["content_view"]="administracion_usuarios_nuevo_view";
					$UIDataModal["close_button"] = true;
					$UIDataModal["classes"] = "modal-lg";
					$UIDataModal["id"] = "usuarios-nuevo-modal";
				}
				$this->load->view('template_modal',$UIDataModal); 
			}else{
				$UIDataModal["title"]="Nuevo usuario";
				if(!filter_var($this->permisos['administracionusuarios']['administracionusuarios-crear'],FILTER_VALIDATE_BOOLEAN)){
					$UIDataModal['content_view']="error_noacceso_view";
				}else{
					$UIDataModal["content_view"]="administracion_usuarios_nuevo_view";
					$UIDataModal["close_button"] = true;
					$UIDataModal["classes"] = "modal-lg";
					$UIDataModal["id"] = "usuarios-nuevo-modal";
				}
				$this->load->view('template_modal',$UIDataModal); 
			}	
		}
		function guardar_usuario(){
			$permisos = array(
				'inventario' => array(
					'inventario-productos-ver'=>$this->input->post('inventario-productos-ver'),
					'inventario-productos-exportar-inventario'=>$this->input->post('inventario-productos-exportar-inventario'),
					'inventario-productos-exportar-catalogo'=>$this->input->post('inventario-productos-exportar-catalogo'),
					'inventario-productos-crear' => $this->input->post('inventario-productos-crear'),
					'inventario-productos-editar' => $this->input->post('inventario-productos-editar'),
					'inventario-productos-eliminar' => $this->input->post('inventario-productos-eliminar'),
					'inventario-productos-kardex' => $this->input->post('inventario-productos-kardex'),
					'inventario-productos-utilidad' => $this->input->post('inventario-productos-utilidad'),
					'inventario-productos-coma' => $this->input->post('inventario-productos-coma'),
					'inventario-productos-comi' => $this->input->post('inventario-productos-comi')					
				),
				'entradas' => array(
					'entradas-ver' => $this->input->post('entradas-ver'),
					'entradas-registrar-compras' => $this->input->post('entradas-registrar-compras'),
					'entradas-registrar-inventario' => $this->input->post('entradas-registrar-inventario'),
				),
				'salidas' => array(
					'salidas-ver' => $this->input->post('salidas-ver'),
					'salidas-dano' => $this->input->post('salidas-dano'),
					'salidas-extravios' => $this->input->post('salidas-extravios'),
					'salidas-devpro' => $this->input->post('salidas-devpro'),
					'salidas-interno' => $this->input->post('salidas-interno'),
					'salidas-facturas' => $this->input->post('salidas-facturas'),
					'salidas-anulcompra' => $this->input->post('salidas-anulcompra')
				),
				'lineas' => array(
					'lineas-crud' => $this->input->post('lineas-crud')
				),
				'facturacion' => array(
					'transacciones-facturacion' => $this->input->post('transacciones-facturacion'),
					'transacciones-devolucion' => $this->input->post('transacciones-devolucion'),
					'transacciones-cortes' => $this->input->post('transacciones-cortes'),
					'transacciones-facnotas' => $this->input->post('transacciones-facnotas'),
					'transacciones-precio1-ver' => $this->input->post('transacciones-precio1-ver'),
					'transacciones-precio2-ver' => $this->input->post('transacciones-precio2-ver'),
					'transacciones-precio3-ver' => $this->input->post('transacciones-precio3-ver'),
					'transacciones-precio4-ver' => $this->input->post('transacciones-precio4-ver'),
					'transacciones-precio5-ver' => $this->input->post('transacciones-precio5-ver'),
					'transacciones-precio6-ver' => $this->input->post('transacciones-precio6-ver')
				),
				'ventas' => array(
					'transacciones-verotros-venta' => $this->input->post('transacciones-verotros-venta'),
					'transacciones-registrar-venta' => $this->input->post('transacciones-registrar-venta'),
					'transacciones-eliminar-venta' => $this->input->post('transacciones-eliminar-venta')
				),
				'cotizaciones' => array(
					'transacciones-verotras-cotizaciones' => $this->input->post('transacciones-verotras-cotizaciones'),
					'transacciones-registrar-cotizaciones' => $this->input->post('transacciones-registrar-cotizaciones'),
					'transacciones-eliminar-cotizaciones' => $this->input->post('transacciones-eliminar-cotizaciones')
				),
				'clientes' => array(
					'clientes-ver' => $this->input->post('clientes-ver'),
					'clientes-crear' => $this->input->post('clientes-crear'),
					'clientes-editar' => $this->input->post('clientes-editar'),
					'clientes-eliminar' => $this->input->post('clientes-eliminar')
				),
				'cuentasxcobrar' => array(
					'cuentasxcobrar-ver' => $this->input->post('cuentasxcobrar-ver'),
					'cuentasxcobrar-autorizar' => $this->input->post('cuentasxcobrar-autorizar'),
					'cuentasxcobrar-modificar' => $this->input->post('cuentasxcobrar-modificar'),
					'cuentasxcobrar-eliminar' => $this->input->post('cuentasxcobrar-eliminar'),
					'cuentasxcobrar-exportar' => $this->input->post('cuentasxcobrar-exportar'),
					'cuentasxcobrar-cargos' => $this->input->post('cuentasxcobrar-cargos'),
					'cuentasxcobrar-abonos' => $this->input->post('cuentasxcobrar-abonos')					
				),
				'proveedores' => array(
					'proveedores-ver' => $this->input->post('proveedores-ver'),
					'proveedores-crear' => $this->input->post('proveedores-crear'),
					'proveedores-editar' => $this->input->post('proveedores-editar'),
					'proveedores-eliminar' => $this->input->post('proveedores-eliminar')
				),
				'cuentasxpagar' => array(
					'cuentasxpagar-ver' => $this->input->post('cuentasxpagar-ver'),
					'cuentasxpagar-eliminar' => $this->input->post('cuentasxpagar-eliminar'),
					'cuentasxpagar-exportar' => $this->input->post('cuentasxpagar-exportar'),
					'cuentasxpagar-cargos' => $this->input->post('cuentasxpagar-cargos'),
					'cuentasxpagar-abonos' => $this->input->post('cuentasxpagar-abonos')
				),
				'reportesventas' => array(
					'reportesventas-comisiones' => $this->input->post('reportesventas-comisiones'),
					'reportesventas-ventas' => $this->input->post('reportesventas-ventas'),
					'reportesventas-utilidades' => $this->input->post('reportesventas-utilidades'),
					'reportesventas-ventaslinea' => $this->input->post('reportesventas-ventaslinea'),
					'reportesventas-ventasvendedor' => $this->input->post('reportesventas-ventasvendedor'),
					'reportesventas-ventasestrellas' => $this->input->post('reportesventas-ventasestrellas')
				),
				'reportesentradas' => array(
					'reportesentradas-compras' => $this->input->post('reportesentradas-compras'),
					'reportesentradas-devoluciones' => $this->input->post('reportesentradas-devoluciones'),
					'reportesentradas-comprasproveedor' => $this->input->post('reportesentradas-comprasproveedor')
				),
				'reportessalidas' => array(
					'reportessalidas-dano' => $this->input->post('reportessalidas-dano'),
					'reportessalidas-extravio' => $this->input->post('reportessalidas-extravio'),
					'reportessalidas-devpro' => $this->input->post('reportessalidas-devpro'),
					'reportessalidas-consumo' => $this->input->post('reportessalidas-consumo')
				),
				'administraciongeneral' => array(
					'administraciongeneral-crud' => $this->input->post('administraciongeneral-crud')
				),
				'administracionfacturacion' => array(
					'administracionfacturacion-ver' => $this->input->post('administracionfacturacion-ver'),
					'administracionfacturacion-cajas' => $this->input->post('administracionfacturacion-cajas'),
					'administracionfacturacion-cortes' => $this->input->post('administracionfacturacion-cortes'),
					'administracionfacturacion-mensaje' => $this->input->post('administracionfacturacion-mensaje')
				),
				'administracionusuarios' => array(
					'administracionusuarios-ver' => $this->input->post('administracionusuarios-ver'),
					'administracionusuarios-crear' => $this->input->post('administracionusuarios-crear'),
					'administracionusuarios-editar' => $this->input->post('administracionusuarios-editar'),
					'administracionusuarios-eliminar' => $this->input->post('administracionusuarios-eliminar')
				),
				'administracionrespaldos' => array(
					'administracionrespaldos-generar-restaurar' => $this->input->post('administracionrespaldos-generar-restaurar')
				)
			);
			
			$data = array(
				'nombre_usuario'			=> $this->input->post('nombre_usuario'),
				'username_usuario'		=> $this->input->post('username_usuario'),
				'estado_usuario'			=> 0,
				'password_usuario'		=> sha1($this->input->post('password_usuario')),
				'permisos_usuario'	    => base64_encode(serialize($permisos))
			);
					
			if($this->input->post('id_usuario') == ''){
				$idusuario = $this->Generic_model->save('usuarios',$data,true);
				echo $this->input->post('nombre_usuario').'‡'.$idusuario;
			}else{			
				if($this->input->post('password_usuario')==""){
					unset($data['password_usuario']);
				}
				$this->Generic_model->update('usuarios',$data,'id_usuario',$this->input->post('id_usuario'));
				echo $this->input->post('nombre_usuario').'‡'.$this->input->post('id_usuario');
			}
		}
		function searchUserName(){
			$result = $this->Generic_model->get('usuarios','*',$wheres=array('username_usuario' => $this->input->get('string')));
			if(count($result ) > 0){
				echo $result[0]->username_usuario;
			}else{
				echo '';
			}
		}
		function cargar_usuarios(){
			$search=array("nombre_usuario"=>$this->input->get('search'));
			$orSearch=array("username_usuario"=>$this->input->get('search'));
			$limits=array(12=>$this->input->get('offset'));
			echo json_encode($this->Generic_model->get('usuarios','id_usuario as id, nombre_usuario as nombre, username_usuario as username,estado_usuario as estado','',array('nombre_usuario'=>'ASC'),$search,'',$limits,'',$orSearch));
		}
		function detalles_usuario(){
			$usuario=$this->Generic_model->get('usuarios','*',array('id_usuario'=>$this->input->get('id')));
			$UIDataModal['usuario']=$usuario[0];
			$UIDataModal['permisos'] = unserialize(base64_decode($usuario[0]->permisos_usuario));
			$UIDataModal['permiso_editarusuario']=filter_var($this->permisos['administracionusuarios']['administracionusuarios-editar'],FILTER_VALIDATE_BOOLEAN);
			$UIDataModal['permiso_eliminarusuario']=filter_var($this->permisos['administracionusuarios']['administracionusuarios-eliminar'],FILTER_VALIDATE_BOOLEAN);
			$this->load->view('administracion_usuarios_detalles_view',$UIDataModal);
		}
		function eliminar_usuario(){
			if(filter_var($this->permisos['administracionusuarios']['administracionusuarios-eliminar'],FILTER_VALIDATE_BOOLEAN)){
				if($this->Generic_model->delete('usuarios','id_usuario',$this->input->get('id'))){
					echo 'Borrado';
				}
			}
		}
		function activar_usuario(){
			if(filter_var($this->permisos['administracionusuarios']['administracionusuarios-editar'],FILTER_VALIDATE_BOOLEAN)){
				if($this->input->get('estado') == 0){
					$estado = 1;
				}else{
					$estado = 0;
				}
				$data=array(
					'estado_usuario'=>$estado
				);
				$this->Generic_model->update('usuarios',$data,'id_usuario',$this->input->get('id'));
			}
		}
		function guardar_imagenperfil(){
			$conf['upload_path'] = './upload_images/';
			$conf['allowed_types'] = 'gif|jpg|png';
			$conf['file_name'] = 'img-perfil'.md5(date('Y-m-d h:m:s'));
			
			$this->load->library('upload', $conf);
			$this->upload->overwrite = true;
		
			if($this->upload->do_upload('admin-usuarios-perfil-foto-file')){
				$uploadData = $this->upload->data();
				$imgPatch ='upload_images/'.$uploadData['orig_name'];
				
				$this->load->library('image_lib');
				
				$config['image_library'] = 'gd2';
				$config['source_image']  = $imgPatch;
				$config['maintain_ratio'] = TRUE;
				$config['height']    = 512;
				$config['width']    = 512;
				
				$this->image_lib->initialize($config);				
				
				if($this->image_lib->resize()){
					$imagen = $imgPatch;
					$this->image_lib->clear();
					/*Crear thumbnail*/
					$thumbConf['image_library']='gd2';
					$thumbConf['source_image']=$imgPatch;
					$thumbConf['new_image'] = './upload_images/thumbs';
					$thumbConf['maintain_ratio']=false;
					$thumbConf['create_thumb']=true;
					$thumbConf['width']=48;
					$thumbConf['height']=48;
					$this->image_lib->initialize($thumbConf);
					if($this->image_lib->resize()){
						$thumbnail="upload_images/thumbs/".$uploadData['raw_name'].'_thumb'.$uploadData['file_ext'];
					}
				}
			}
			
			$data=array(
				'perfil_usuario'=>$imagen,
				'thumb_usuario'=>$thumbnail
			);
			
			$this->Generic_model->update('usuarios',$data,'id_usuario',$this->input->post('id_usuario_perfil'));
			
			echo base_url($imagen)."‡".base_url($thumbnail);
		}
		function nueva_meta(){
			$UIDataModal["title"]="Nueva meta";
			$UIDataModal["content_view"]="administracion_usuarios_meta_nueva_view";
			$UIDataModal["close_button"] = true;
			$UIDataModal["classes"] = "modal-md";
			$UIDataModal["id"] = "meta-nueva-modal";
			$UIDataModal["usuario"] =$this->input->get('usuario');
			if($this->input->get("meta")){
				$meta=$this->Generic_model->get('metas','*',array('id_meta'=>$this->input->get("meta")));
				$UIDataModal["meta"]=$meta[0];
			}
			$this->load->view('template_modal',$UIDataModal);
		}
			function guardar_meta(){
				$data = array(
					"id_usuario"=>$this->input->post("id_usuario"),
					"monto_meta"=>$this->input->post("monto_meta"),
					"inicio_meta"=>$this->input->post("inicio_meta"),
					"fin_meta"=>$this->input->post("fin_meta"),
				);
				
				if($this->input->post('id_meta') == ''){
					if($this->Generic_model->save('metas',$data))
						echo "guardado";
				}else{			
					if($this->Generic_model->update('metas',$data,'id_meta',$this->input->post('id_meta')))
						echo "actualizado";
				}
			}
			
			function eliminar_meta(){
				if($this->Generic_model->delete('metas','id_meta',$this->input->get('id'))){
					echo 'Borrado';
				}
			}
		function cargar_metas(){
			$this->load->library("ssp");
		
			$table = 'metas';
			$primaryKey = 'id_meta';
			
			$columns = array(
				array(
					'db' => '`m`.`inicio_meta`',
					'dt' => 0,
					'field' => 'inicio_meta',
					'formatter' => function($d,$row){
						$dateConvert = explode('-',$d);
						return $dateConvert[2].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0];
					}
				),
				array(
					'db' => '`m`.`fin_meta`',
					'dt' => 1,
					'field' => 'fin_meta',
					'formatter' => function($d,$row){
						$dateConvert = explode('-',$d);
						return $dateConvert[2].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0];
					}
				),
				array( 'db' => '`m`.`monto_meta`','dt' => 2, 'field' => 'monto_meta' ),
				array(
					'db' => '`m`.`id_meta`',
					'dt' => 3,
					'field' => 'id_meta',
					'formatter' => function( $d, $row ) {
						$datatarget = base_url('administracion/nueva_meta?meta='.$d."&usuario=".$row[4]);
						if($this->input->post("singleUser") == "0"){
							return '<a target="_blank" href="'.base_url().'reportes/reporte_comisiones_vendedor?reference=datatables&vendedor='.$row[4].'&meta='.$d.'" class="btn btn-success btn-xs">Ver</a>';
						}else if($this->input->post("reference") == 'users'){
							return '<a target="_blank" href="'.base_url().'reportes/reporte_comisiones_vendedor?reference=none&vendedor='.$row[4].'&meta='.$d.'" class="btn btn-success btn-xs">Ver</a> <button data-target="'.$datatarget.'" class="btn btn-info btn-xs modal-trigger">Editar</button> <button class="btn btn-danger btn-xs" onclick="usuarios.eliminar_meta('.$d.','.$row[2].')">Eliminar</button>';
						}else{
							return '<a target="_blank" href="'.base_url().'reportes/reporte_comisiones_vendedor?reference=datatables&vendedor='.$row[4].'&meta='.$d.'" class="btn btn-success btn-xs">Ver</a> <button data-target="'.$datatarget.'" class="btn btn-info btn-xs modal-trigger">Editar</button> <button class="btn btn-danger btn-xs" onclick="usuarios.eliminar_meta('.$d.','.$row[2].')">Eliminar</button>';
						}
					}
				),
				array( 'db' => '`m`.`id_usuario`','dt' => 4, 'field' => 'id_usuario' ),
			);
			$host =  explode(':',$this->db->hostname);
			$sql_details = array(
				'user' => $this->db->username,
				'pass' => $this->db->password,
				'db'   => $this->db->database,
				'host' => $host[0]
			);
			
			/*$joinQuery = "FROM `user` AS `u` JOIN `user_details` AS `ud` ON (`ud`.`user_id` = `u`.`id`)";
			$extraWhere = "`u`.`salary` >= 90000";*/
			$joinQuery = "FROM `metas` AS `m`";
			$extraWhere = "`m`.`id_usuario` =".$this->input->post("idUser");
			 
			echo json_encode(
				$this->ssp->simple($this->input->post(), $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere)
			);
		}
	/*------------------------- SEGURIDAD ----------------------*/
	function seguridad(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']	= "Administraci&oacute;n de seguridad";
		if(!filter_var($this->permisos['administracionrespaldos']['administracionrespaldos-generar-restaurar'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
		}else{
			$UIData['main_view']	= "administracion_seguridad_view";
			$UIData['plugins_header']=array(
				array(
					"nombre"=>"fileinput",
					"js"=> array('fileinput','fileinput_locale_es'),
					"css"=> array('fileinput')
				),
				array(
					"nombre"=>"zebra",
					"js"=> array('zebra_dialog'),
					"css"=> array('zebra_dialog')
				),
				array(
					"nombre"=>"datatables",
					"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
					"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
				),
			);
		}
		$this->load->view('template', $UIData);
	}
	
	function respaldos_info(){
		$configuraciones = $this->Generic_model->get('configuraciones');
		$configs = array();		
		foreach($configuraciones as $config){
			$configs[$config->campo_config] = $config->valor_config;
		}
		$data['configs'] = $configs;
		$this->load->view('administracion_respaldos_info_view',$data); 
	}
	
	function upload_respaldo(){
		$conf['upload_path'] = './upload_backups/';
		$conf['allowed_types'] = '*';
		
		$this->load->library('upload', $conf);
		$this->upload->overwrite = true;
	
		if($this->upload->do_upload('file-4')){
			$uploadData = $this->upload->data();
			$databasePath = $_SERVER["DOCUMENT_ROOT"].'/miracle15/upload_backups/'.$uploadData['orig_name'];
			
			$filename = $databasePath;				
			echo json_encode($filename);
		}else{
			echo json_encode($this->upload->display_errors('', ''));
		}
	}
	
	function replace_database(){
		$filename = $this->input->post("backup");
		
		$host =  explode(':',$this->db->hostname);
		$mysqli = new mysqli($host[0],$this->db->username,$this->db->password,$this->db->database);

		if (mysqli_connect_errno()) {
			printf("Connect failed: %s\n", mysqli_connect_error());
			exit();
		}
		
		$templine = '';
		$lines = file($filename);
		foreach ($lines as $line)
		{

		if (substr($line, 0, 2) == '--' || $line == '')
			continue;

		$templine .= $line;

		if (substr(trim($line), -1, 1) == ';')
		{
			$mysqli->query($templine);
			$templine = '';
		}
		}
		$this->Generic_model->update('configuraciones',$data = array('valor_config' => array_pop(explode("/",$filename))),'campo_config','NombreUltimoRespaldoRestaurado');
	}
	
	function generate_backup(){
		$host =  explode(':',$this->db->hostname);
		$this->backup_database( $_SERVER["DOCUMENT_ROOT"].'/miracle15pre/generated_backup', "miracle15", $host[0], $this->db->username, $this->db->password, $this->db->database);
	}
	
	function backup_database( $directory, $outname , $dbhost, $dbuser, $dbpass ,$dbname ) {
		$this->load->helper('file');
		//$configuraciones = $this->Generic_model->get('configuraciones');
		$dias = array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sábado");
		$meses = array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
		$fechaDeLaCopia = substr($dias[date('w')],0,3)."-".date('d')."-".substr($meses[date('n')-1],0,3). "-".date('Y')."-".gmdate('H_i_s', strtotime('- 6 hours'));
		
		$this->Generic_model->update('configuraciones',$data = array('valor_config' => date("Y-m-d")),'campo_config','FechaUltimoRespaldo');
		$this->Generic_model->update('configuraciones',$data = array('valor_config' => "Backup-".$dbname."_".$fechaDeLaCopia.'.v1-5-0'.".sql"),'campo_config','NombreUltimoRespaldoGenerado');

		  if( ! function_exists('mysqli_connect') ) {
			die(' This scripts need mysql extension to be running properly ! please resolve!!');
		  }
			$mysqli = @new mysqli($dbhost, $dbuser, $dbpass, $dbname);
			
			if( $mysqli->connect_error ) {
				print_r( $mysqli->connect_error );
				return false;
			}
			$dir = $directory;
			$result = '<p> Could not create backup directory on :'.$dir.' Please Please make sure you have set Directory on 755 or 777 for a while.</p>';  
			$res = true;
			if( ! is_dir( $dir ) ) {
			  if( ! @mkdir( $dir, 755 )) {
				$res = false;
			  }
			}
		  $n = 1;
		  if( $res ) {
			$name     = $outname;
			# counts
			if( file_exists($dir.'/'.$name.'.sql.gz' ) ) {
			  for($i=1;@count( file($dir.'/'.$name.'_'.$i.'.sql.gz') );$i++){
				$name = $name;
				if( ! file_exists( $dir.'/'.$name.'_'.$i.'.sql.gz') ) {
				  $name = $name.'_'.$i;
				  break;
				}
			  }
			}
			$fullname = $dir.'/'.$name.'.sql.gz'; # full structures
			if( ! $mysqli->error ) {
			  $sql = "SHOW TABLES";
			  $show = $mysqli->query($sql);
			  while ( $r = $show->fetch_array() ) {
				$tables[] = $r[0];
			  }
			  if( ! empty( $tables ) ) {
		  //cycle through
		  $return = '';
		  foreach( $tables as $table )
		  {
			$result     = $mysqli->query('SELECT * FROM '.$table);
			$num_fields = $result->field_count;
			$return.= 'DROP TABLE '.$table.';';
			$row2       = $mysqli->query('SHOW CREATE TABLE '.$table );
			$row2       = $row2->fetch_row();
			$return    .= 
		"\n
		-- ---------------------------------------------------------
		--
		-- Table structure for table : `{$table}`
		--
		-- ---------------------------------------------------------
		".$row2[1].";\n";
			for ($i = 0; $i < $num_fields; $i++) 
			{
			  $n = 1 ;
			  while( $row = $result->fetch_row() )
			  { 
				
				if( $n++ == 1 ) { # set the first statements
				  $return .= 
		"
		--
		-- Dumping data for table `{$table}`
		--
		";  
				/**
				 * Get structural of fields each tables
				 */
				$array_field = array(); #reset ! important to resetting when loop 
				 while( $field = $result->fetch_field() ) # get field
				{
				  $array_field[] = '`'.$field->name.'`';
				  
				}
				$array_f[$table] = $array_field;
				// $array_f = $array_f;
				# endwhile
				$array_field = implode(', ', $array_f[$table]); #implode arrays
				  $return .= "INSERT INTO `{$table}` ({$array_field}) VALUES\n(";
				} else {
				  $return .= '(';
				}
				for($j=0; $j<$num_fields; $j++) 
				{
				  
				  $row[$j] = str_replace('\'','\'\'', preg_replace("/\n/","\\n", $row[$j] ) );
				  if ( isset( $row[$j] ) ) { $return .= is_numeric( $row[$j] ) ? $row[$j] : '\''.$row[$j].'\'' ; } else { $return.= '\'\''; }
				  if ($j<($num_fields-1)) { $return.= ', '; }
				}
				  $return.= "),\n";
			  }
			  # check matching
			  @preg_match("/\),\n/", $return, $match, false, -3); # check match
			  if( isset( $match[0] ) )
			  {
				$return = substr_replace( $return, ";\n", -2);
			  }
			}
			
			  $return .= "\n";
		  }
		$return = 
		"
		-- ---------------------------------------------------------------------------------------------------------------------------------------------------------
		--
		-- Codigo SQL Generado por Miracle v1.5.0 - Xypnos Soluciones Tecnologicas, Todos los Derechos Reservados
		--
		-- ---------------------------------------------------------------------------------------------------------------------------------------------------------\n
		SET FOREIGN_KEY_CHECKS=0;\n\n			
		".$return;
			
			write_file($directory."/Backup-".$dbname."_".$fechaDeLaCopia.'.v1-5-0'.".sql",$return);
			write_file("C:/Users/Servidor/Documents/MEGA/Backup-".$dbname."_".$fechaDeLaCopia.'.v1-5-0'.".sql",$return);
			
			echo "Backup-".$dbname."_".$fechaDeLaCopia.'.v1-5-0'.".sql";
			
			   } else {
				 $result = '<p>Error when executing database query to export.</p>'.$mysqli->error;
			   
			   }
			 }
		 } else {
			  $result = '<p>Wrong mysqli input</p>';
		 }
		 
		 if( $mysqli && ! $mysqli->error ) {
			  @$mysqli->close();
		 }
		  return $result;
	}
	
	function TraducirMes($month){
		switch($month){
			case '01':
					return $mes = 'Enero';
				break;
			case '02':
					return $mes = 'Febrero';
				break;
			case '03':
					return $mes = 'Marzo';
				break;
			case '04':
					return $mes = 'Abril';
				break;
			case '05':
					return $mes = 'Mayo';
				break;
			case '06':
					return $mes = 'Junio';
				break;
			case '07':
					return $mes = 'Julio';
				break;
			case '08':
					return $mes = 'Agosto';
				break;
			case '09':
					return $mes = 'Septiembre';
				break;
			case '10':
					return $mes = 'Octubre';
				break;
			case '11':
					return $mes = 'Noviembre';
				break;
			case '12':
					return $mes = 'Diciembre';
				break;
		}
	}
	function is_logged_in(){
		$session = $this->session->userdata('userInfo');
		$is_logged_in =$session['is_logged_in'];
		
		if(!isset($is_logged_in) || $is_logged_in !== true){
			redirect(base_url("login"));
			die();
		}
	}
}
?>