<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$acum = 0;
	
	/*Init*/
	$printer = printer_open("EPSON TM-U950 Slip");

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Factura Numero: '.$doc_numero);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 9, 7, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	/*Ghost*/
	$phpPrinter->printString(strtoupper(utf8_decode(substr(" ",0,24))),2,$printer,$acum,13,11,70);
	$phpPrinter->tabPrinter($acum,100);

	$phpPrinter->printString(date("d"),2,$printer,$acum,13,11,540);
	$phpPrinter->printString(date("m"),2,$printer,$acum,13,0,610);
	$phpPrinter->printString(date("Y"),2,$printer,$acum,13,0,700);
	$phpPrinter->tabPrinter($acum,10);
	$phpPrinter->printString(strtoupper(utf8_decode($cliente)),2,$printer,$acum,13,11,160);
	$phpPrinter->tabPrinter($acum,5);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($direccion_cliente,0,20))),2,$printer,$acum,13,11,180);
	//$phpPrinter->printString(strtoupper(utf8_decode(substr($vendedor[0]->nombre_usuario,0,10))),2,$printer,$acum,13,0,585);
	//$phpPrinter->tabPrinter($acum,15);
	//$phpPrinter->printString(strtoupper(utf8_decode(substr($nrc_cliente,0,20))),2,$printer,$acum,13,11,60);
	$phpPrinter->tabPrinter($acum,35);
	
	/*Body*/
	foreach($productos_normal as $producto){
		$phpPrinter->printString(number_format($producto->cant,2),2,$printer,$acum,9,7,50);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc))),30),2,$printer,$acum,9,0,110);
		$phpPrinter->printString(number_format($producto->costo,2),2,$printer,$acum,9,0,525);
		$phpPrinter->printString(number_format($producto->cant * $producto->costo,2),2,$printer,$acum,9,0,700);
		$phpPrinter->tabPrinter($acum,3);
	}
	
	/*Footer*/
	printer_draw_text($printer,$phpInletters->ValorEnLetras($totales['totalTotal'],""), 80, 440);
	printer_draw_text($printer,"Ref:".$referencia, 80, 460);
	printer_draw_text($printer,$totales['totalGrabadas'], 700, 425);
	//printer_draw_text($printer,$totales['totalIVA'], 675, 430);
	printer_draw_text($printer,$totales['totalExento'], 700, 450);
	printer_draw_text($printer,$totales['totalNS'], 700, 464);
	printer_draw_text($printer,$totales['totalTotal'], 700, 490);
	printer_draw_text($printer,$totales['totalTotal'], 700, 530);
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>