<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa'])
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],185,5,25);
            $this->SetFont('Arial','B',11);
            $this->SetY(6);
            $this->Cell(0,7,utf8_decode('Cortes y Detalle de Transacciones'),0,1,'C');
            $this->SetFont('Arial','B',10);
            $this->SetY(12);
            $this->Cell(0,7,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'C');
            $this->SetY(17);
            $this->Cell(0,7,strtoupper(utf8_decode($dataArray['Direccion'])),0,1,'C');
            $this->Ln(2);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(135,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(50,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(50,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Cortes y Detalle de Transacciones');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    
	if($printCorteFiscal):
	$pdf->AddPage('P','Letter');
    
    /*Corte Fiscal*/
    $pdf->Cell(196,7,utf8_decode(strtoupper("Corte Fiscal")),0,1,'C');
    $pdf->Cell(196,7,utf8_decode(ucwords("Total ".$tipo_corte. " numero ".$numero_corte)),0,1,'C');
	$pdf->Ln(2);
	
	$facturas = $dataCorteFiscal['total_factura_grabado']+$dataCorteFiscal['total_factura_exento']+$dataCorteFiscal['total_factura_nosujeto'];
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Total Facturas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($facturas),0,1,'R');
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$pdf->SetFont('Arial','',10);
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Total Gravadas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_factura_grabado']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Total Exentas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_factura_exento']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Total No Sujetas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_factura_nosujeto']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	
	$pdf->SetLineWidth(0.4);
	$pdf->SetDrawColor(0,0,0);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->Ln(2);
	$pdf->SetFont('Arial','B',10);	
	
	$ccf = $dataCorteFiscal['total_ccf_grabado']+$dataCorteFiscal['total_ccf_exento']+$dataCorteFiscal['total_ccf_nosujeto'];
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Total CCF"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($ccf),0,1,'R');
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$pdf->SetFont('Arial','',10);
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Total Gravadas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_ccf_grabado']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Total Exentas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_ccf_exento']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Total No Sujetas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_ccf_nosujeto']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$pdf->SetLineWidth(0.4);
	$pdf->SetDrawColor(0,0,0);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->Ln(2);
	$pdf->SetFont('Arial','B',10);	
	
	$tickets = $dataCorteFiscal['total_ticket_grabado']+$dataCorteFiscal['total_ticket_exento']+$dataCorteFiscal['total_ticket_nosujeto'];
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Total Tickets"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($tickets),0,1,'R');
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$pdf->SetFont('Arial','',10);
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Total Gravadas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_ticket_grabado']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Total Exentas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_ticket_exento']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Total No Sujetas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_ticket_nosujeto']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$pdf->SetLineWidth(0.4);
	$pdf->SetDrawColor(0,0,0);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->Ln(2);
	$pdf->SetFont('Arial','B',10);	
	
	$devs = $dataCorteFiscal['total_devolucion_factura']+$dataCorteFiscal['total_devolucion_ccf']+$dataCorteFiscal['total_devolucion_ticket']+$dataCorteFiscal['total_devolucion_ncredito'];
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Total Devoluciones"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode("(".$devs.")"),0,1,'R');
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$pdf->SetFont('Arial','',10);
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Devolucion Facturas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_devolucion_factura']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Devolucion CCF"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_devolucion_ccf']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Devolucion Tickets"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_devolucion_ticket']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(50);
	$pdf->Cell(45,7,utf8_decode("Devolucion Nota de Credito"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataCorteFiscal['total_devolucion_ncredito']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$pdf->SetLineWidth(0.4);
	$pdf->SetDrawColor(0,0,0);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetFont('Arial','B',10);
	
	$total = ($facturas+$ccf+$tickets) - $devs;
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Total En Ventas"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($total),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	/*Contadores*/
	$pdf->SetFont('Arial','',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Facturas Emitidas"),0,0,'L');
	$pdf->Cell(30,7,utf8_decode($dataCorteFiscal['total_trans_factura']),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());	
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("CCF Emitidos"),0,0,'L');
	$pdf->Cell(30,7,utf8_decode($dataCorteFiscal['total_trans_ccf']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());	
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Notas de Credito Emitidas"),0,0,'L');
	$pdf->Cell(30,7,utf8_decode($dataCorteFiscal['total_trans_ncredito']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());	
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Tickets Emitidos"),0,0,'L');
	$pdf->Cell(30,7,utf8_decode($dataCorteFiscal['total_trans_ticket']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());	
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Tickets Inicio"),0,0,'L');
		$pdf->Cell(30,7,utf8_decode($dataCorteFiscal['ticketInicio']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());	
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Tickets Fin"),0,0,'L');
		$pdf->Cell(30,7,utf8_decode($dataCorteFiscal['ticketFin']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());	
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Devoluciones(Tickets)"),0,0,'L');
	$pdf->Cell(30,7,utf8_decode($dataCorteFiscal['total_trans_ticket_dev']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());	
	
	$pdf->SetLineWidth(0.4);
	$pdf->SetDrawColor(0,0,0);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$trans = $dataCorteFiscal['total_trans_ticket']+$dataCorteFiscal['total_trans_ticket_dev']+$dataCorteFiscal['total_trans_factura']+$dataCorteFiscal['total_trans_ccf']+$dataCorteFiscal['total_trans_ncredito'];
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("No Trans. Realizadas"),0,0,'L');
	$pdf->Cell(30,7,utf8_decode($trans),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	endif;
	
	if($printAnexoMedio):
	$pdf->AddPage('P','Letter');
	
	/*Anexo Medio de Pago*/
	$pdf->SetFont('Arial','B',10);
    $pdf->Cell(196,7,utf8_decode(strtoupper("Anexo 1 de Corte ".$tipo_corte." numero: ".$numero_corte)),0,1,'C');
    $pdf->Cell(196,7,utf8_decode(ucwords("Resumen de Ingresos segun Medio")),0,1,'C');
	$pdf->Ln(2);
	
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("EFECTIVO"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_efectivo'] - $dataAnexoMedio['total_devoluciones_efectivo']),0,1,'R');
	$pdf->SetFont('Arial','',10);
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Ingresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_efectivo']),0,1,'R');
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Egresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode("(".$dataAnexoMedio['total_devoluciones_efectivo'].")"),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->Ln(2);
	
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("CHEQUE"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_cheque'] - $dataAnexoMedio['total_devoluciones_cheque']),0,1,'R');
	$pdf->SetFont('Arial','',10);
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Ingresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_cheque']),0,1,'R');
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Egresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode("(".$dataAnexoMedio['total_devoluciones_cheque'].")"),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->Ln(2);
	
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("POS"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_pos'] - $dataAnexoMedio['total_devoluciones_pos']),0,1,'R');
	$pdf->SetFont('Arial','',10);
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Ingresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_pos']),0,1,'R');
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Egresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode("(".$dataAnexoMedio['total_devoluciones_pos'].")"),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->Ln(2);
	
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("ABONOS A CUENTA"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_cuenta'] - $dataAnexoMedio['total_devoluciones_cuenta']),0,1,'R');
	$pdf->SetFont('Arial','',10);
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Ingresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_cuenta']),0,1,'R');
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Egresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode("(".$dataAnexoMedio['total_devoluciones_cuenta'].")"),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->Ln(2);
	
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("PAGO ELECTRONICO"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_electronico'] - $dataAnexoMedio['total_devoluciones_electronico']),0,1,'R');
	$pdf->SetFont('Arial','',10);
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Ingresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['total_ventas_electronico']),0,1,'R');
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Egresos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode("(".$dataAnexoMedio['total_devoluciones_electronico'].")"),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->Ln(2);
	
	$total_ingresos = $dataAnexoMedio['total_ventas_efectivo']+$dataAnexoMedio['total_ventas_cheque']+$dataAnexoMedio['total_ventas_pos']+$dataAnexoMedio['total_ventas_cuenta']+$dataAnexoMedio['total_ventas_electronico'];
	$total_egresos = $dataAnexoMedio['total_devoluciones_efectivo']+$dataAnexoMedio['total_devoluciones_cheque']+$dataAnexoMedio['total_devoluciones_pos']+$dataAnexoMedio['total_devoluciones_cuenta']+$dataAnexoMedio['total_devoluciones_electronico'];
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("INGRESO NETO"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	if($total_ingresos < $total_egresos){
		$pdf->Cell(20,7,utf8_decode("(".$total_ingresos - $total_egresos.")"),0,1,'L');
	}else{
		$pdf->Cell(20,7,utf8_decode($total_ingresos - $total_egresos),0,1,'R');
	}
	$pdf->SetFont('Arial','',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Dotaciones"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataAnexoMedio['dotacion']),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("INGRESO BRUTO"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	if((($total_ingresos + $dataAnexoMedio['dotacion']) < $total_egresos)){
		$pdf->Cell(20,7,utf8_decode("(".($total_ingresos + $dataAnexoMedio['dotacion']) - $total_egresos.")"),0,1,'L');
	}else{
		$pdf->Cell(20,7,utf8_decode(($total_ingresos + $dataAnexoMedio['dotacion']) - $total_egresos),0,1,'R');	
	}
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetFont('Arial','',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Anticipos anteriores"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode("(".$dataAnexoMedio['total_anticipos_anteriores'].")"),0,1,'R');
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("TOTAL"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	if((($total_ingresos + $dataAnexoMedio['dotacion']) < ($total_egresos+$dataAnexoMedio['total_anticipos_anteriores']))){
		$pdf->Cell(20,7,utf8_decode("(".($total_ingresos + $dataAnexoMedio['dotacion']) - ($total_egresos+$dataAnexoMedio['total_anticipos_anteriores']).")"),0,1,'L');
	}else{
		$pdf->Cell(20,7,utf8_decode(($total_ingresos + $dataAnexoMedio['dotacion']) - ($total_egresos+$dataAnexoMedio['total_anticipos_anteriores'])),0,1,'R');	
	}
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	endif;
	
	if($printAnexoDocumento):
	$pdf->AddPage('P','Letter');
	
	/*Anexo Resumen del Ingreso segun Documento y Forma*/
	$pdf->SetFont('Arial','B',10);
    $pdf->Cell(196,7,utf8_decode(strtoupper("Anexo 2 de Corte ".$tipo_corte." numero: ".$numero_corte)),0,1,'C');
    $pdf->Cell(196,7,utf8_decode(ucwords("Resumen del Ingreso segun Documento y Forma")),0,1,'C');
	$pdf->Ln(2);
	
	$ingresos_contado = $dataAnexoDocumento['total_contado_sdocumento']+$dataAnexoDocumento['total_contado_factura']+$dataAnexoDocumento['total_contado_ccf']+$dataAnexoDocumento['total_contado_ticket']+$dataAnexoDocumento['total_contado_ticketrecibo']+$dataAnexoDocumento['total_contado_nremision']+$dataAnexoDocumento['total_recibos']+$dataAnexoDocumento['total_contado_nenvio']+$dataAnexoDocumento['total_abonos_pedido'];
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Ingresos Contado"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($ingresos_contado),0,1,'R');
	$pdf->SetFont('Arial','',10);
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Facturas"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_contado_factura']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("CCF"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_contado_ccf']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Tickets"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_contado_ticket']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Comprobantes"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_contado_ticketrecibo']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Remision"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_contado_nremision']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Envio"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_contado_nenvio']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Recibos"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_recibos']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Ant. orden de Pedido"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_abonos_pedido']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Sin documento"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_contado_sdocumento']),0,1,'R');
		$pdf->SetLineWidth(0.4);
		$pdf->SetDrawColor(0,0,0);
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		
	$devoluciones_contado = $dataAnexoDocumento['total_devolucion_sdocumento_contado']+$dataAnexoDocumento['total_devolucion_factura_contado']+$dataAnexoDocumento['total_devolucion_ccf_contado']+$dataAnexoDocumento['total_devolucion_ticket_contado']+$dataAnexoDocumento['total_devolucion_ticketrecibo_contado']+$dataAnexoDocumento['total_devolucion_nremision_contado']+$dataAnexoDocumento['total_devolucion_nenvio_contado']+$dataAnexoDocumento['total_devolucion_ncredito_contado'];
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Devoluciones Contado"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode("(".$devoluciones_contado.")"),0,1,'R');
	$pdf->SetFont('Arial','',10);
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Facturas"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_factura_contado']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("CCF"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_ccf_contado']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Tickets"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_ticket_contado']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Comprobantes"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_ticketrecibo_contado']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Remision"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_nremision_contado']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Envio"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_nenvio_contado']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Credito"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_ncredito_contado']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Sin documento"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_sdocumento_contado']),0,1,'R');
		$pdf->SetLineWidth(0.4);
		$pdf->SetDrawColor(0,0,0);
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("TOTAL CONTADO BRUTO"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	if(($ingresos_contado - $devoluciones_contado) < 0){
		$pdf->Cell(20,7,utf8_decode("(".($ingresos_contado - $devoluciones_contado).")"),0,1,'L');
	}else{
		$pdf->Cell(20,7,utf8_decode(($ingresos_contado - $devoluciones_contado)),0,1,'R');	
	}
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetFont('Arial','',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Dotacion"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['dotacion']),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("TOTAL CONTADO BRUTO + DOTACION"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	if((($ingresos_contado+$dataAnexoDocumento['dotacion']) - $devoluciones_contado) < 0){
		$pdf->Cell(20,7,utf8_decode("(".($ingresos_contado - $devoluciones_contado).")"),0,1,'L');
	}else{
		$pdf->Cell(20,7,utf8_decode((($ingresos_contado+$dataAnexoDocumento['dotacion']) - $devoluciones_contado)),0,1,'R');	
	}
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetFont('Arial','',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Anticipos anteriores"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode("(".$dataAnexoDocumento['total_anticipos_anteriores'].")"),0,1,'R');
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	$pdf->SetX(40);
	$pdf->SetFont('Arial','B',10);
	$pdf->Cell(90,7,utf8_decode("TOTAL CONTADO NETO"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	if((($ingresos_contado+$dataAnexoDocumento['dotacion']) - ($devoluciones_contado+$dataAnexoDocumento['total_anticipos_anteriores'])) < 0){
		$pdf->Cell(20,7,utf8_decode("(".(($ingresos_contado+$dataAnexoDocumento['dotacion']) - ($devoluciones_contado+$dataAnexoDocumento['total_anticipos_anteriores'])).")"),0,1,'L');
	}else{
		$pdf->Cell(20,7,utf8_decode((($ingresos_contado+$dataAnexoDocumento['dotacion']) - ($devoluciones_contado+$dataAnexoDocumento['total_anticipos_anteriores']))),0,1,'R');	
	}
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$pdf->AddPage('P','Letter');
	
	$ingresos_credito = $dataAnexoDocumento['total_credito_sdocumento']+$dataAnexoDocumento['total_credito_factura']+$dataAnexoDocumento['total_credito_ccf']+$dataAnexoDocumento['total_credito_ticket']+$dataAnexoDocumento['total_credito_ticketrecibo']+$dataAnexoDocumento['total_credito_nremision']+$dataAnexoDocumento['total_credito_nenvio'];
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Credito generado"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($ingresos_credito),0,1,'R');
	$pdf->SetFont('Arial','',10);
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Facturas"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_credito_factura']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("CCF"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_credito_ccf']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Tickets"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_credito_ticket']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Comprobantes"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_credito_ticketrecibo']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Remision"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_credito_nremision']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Envio"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_credito_nenvio']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Sin documento"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_credito_sdocumento']),0,1,'R');
		$pdf->SetLineWidth(0.4);
		$pdf->SetDrawColor(0,0,0);
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		
	$devoluciones_credito = $dataAnexoDocumento['total_devolucion_sdocumento_credito']+$dataAnexoDocumento['total_devolucion_factura_credito']+$dataAnexoDocumento['total_devolucion_ccf_credito']+$dataAnexoDocumento['total_devolucion_ticket_credito']+$dataAnexoDocumento['total_devolucion_ticketrecibo_credito']+$dataAnexoDocumento['total_devolucion_nremision_credito']+$dataAnexoDocumento['total_devolucion_nenvio_credito']+$dataAnexoDocumento['total_devolucion_ncredito_credito'];
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Devoluciones credito"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode("(".$devoluciones_credito.")"),0,1,'R');
	$pdf->SetFont('Arial','',10);
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Facturas"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_factura_credito']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("CCF"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_ccf_credito']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Tickets"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_ticket_credito']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Comprobantes"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_ticketrecibo_credito']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Remision"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_nremision_credito']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Envio"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_nenvio_credito']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Notas de Credito"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_ncredito_credito']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Sin documento"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_devolucion_sdocumento_credito']),0,1,'R');
		$pdf->SetLineWidth(0.4);
		$pdf->SetDrawColor(0,0,0);
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		
	$pdf->SetFont('Arial','B',10);
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("TOTAL CREDITO NETO"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	if(($ingresos_credito - $devoluciones_credito) < 0){
		$pdf->Cell(20,7,utf8_decode("(".($ingresos_credito - $devoluciones_credito).")"),0,1,'L');
	}else{
		$pdf->Cell(20,7,utf8_decode(($ingresos_credito - $devoluciones_credito)),0,1,'R');	
	}
	$pdf->SetLineWidth(0.4);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
	
	$siningreso = $dataAnexoDocumento['total_singreso_sdocumento']+$dataAnexoDocumento['total_singreso_factura']+$dataAnexoDocumento['total_singreso_ccf']+$dataAnexoDocumento['total_singreso_ticket']+$dataAnexoDocumento['total_singreso_ticketrecibo'];
	$pdf->SetX(40);
	$pdf->Cell(90,7,utf8_decode("Total sin Ingreso"),0,0,'L');
	$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
	$pdf->Cell(20,7,utf8_decode($siningreso),0,1,'R');
	$pdf->SetFont('Arial','',10);
	$pdf->SetLineWidth(0.2);
	$pdf->SetDrawColor(205,205,205);
	$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Facturas"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_singreso_factura']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("CCF"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_singreso_ccf']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Tickets"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_singreso_ticket']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Comprobantes"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_singreso_ticketrecibo']),0,1,'R');
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());
		$pdf->SetX(50);
		$pdf->Cell(45,7,utf8_decode("Sin documento"),0,0,'L');
		$pdf->Cell(10,7,utf8_decode("$"),0,0,'R');
		$pdf->Cell(20,7,utf8_decode($dataAnexoDocumento['total_singreso_sdocumento']),0,1,'R');
		$pdf->SetLineWidth(0.4);
		$pdf->SetDrawColor(0,0,0);
		$pdf->Line(40,$pdf->GetY(),160,$pdf->GetY());	
	endif;
	
    /*Exportamos el PDF*/
    $pdf->Output('Cortes y Detalle de Transacciones','I');
?>