<?php
	$this->load->library('fpdf');
	
	$GLOBALS['dataArray'] = array(
        'Empresa' => $configs['NombreEmpresa'],
        'Direccion' => $configs['DireccionEmpresa'],
        'Logo' => base_url($configs['LogoEmpresa']),
        'Telefono' => $configs['TelefonoEmpresa'],
		'Numero' => $cotizacion->id_cotizacion
    );
	
	class PDF extends FPDF{
    
        function Header(){
            global $dataArray;
            $this->Image($dataArray['Logo'],10,15,25);
            $this->SetFont('Arial','B',12);
            $this->SetY(6);
            $this->Cell(0,8,strtoupper(utf8_decode('Cotizacion N° '.$dataArray['Numero'])),0,1,'L');
            $this->SetFont('Arial','B',10);
            $this->SetY(6);
            $this->Cell(0,8,strtoupper(utf8_decode($dataArray['Empresa'])),0,1,'R');
			$this->SetFont('Arial','',10);
            $this->SetY(12);
            $this->Cell(0,8,utf8_decode($dataArray['Direccion']),0,1,'R');
			$this->SetY(18);
            $this->Cell(0,8,utf8_decode("Telefono: ".$dataArray['Telefono']),0,1,'R');
            $this->Ln(3);
			
			$this->SetFont('Arial','',11);
        }
        
        function Footer(){
            $this->SetY(-15);
            $this->SetFont('Arial','I',7);
            $this->Cell(135,6,utf8_decode('Pagina '.$this->PageNo().'/{nb}'),0,0,'L');
            $this->Cell(40,6,utf8_decode(gmdate('d-m-Y H:i:s', strtotime('- 6 hours'))),0,1,'R');
            $this->Cell(40,6,utf8_decode('Miracle v1.5 - Todos los Derechos Reservados 2012 - '.date('Y').' - Xypnos Soluciones Tecnologicas'),0,1,'L');
        }
    }
	
	$detalles_cotizacion = $detalles['detalles'];
	
	$pdf = new PDF();
    $pdf->AliasNbPages(); 
    $pdf->setTitle('Reporte de Cotizacion');
    $pdf->setAuthor('Miracle v1.5 - Xypnos');
    $pdf->AddPage('P','Letter');
    
    /*Cuerpo del Documento*/
	$dateConvert = explode('-',substr($cotizacion->fecha_cotizacion,0,10));
	$pdf->Cell(0,8,utf8_decode($dateConvert[2].' de '.TraducirMes($dateConvert[1]).' del '.$dateConvert[0]),0,1,'R');
    $pdf->Ln(5);
	$pdf->SetFont('Arial','B',10);
	$pdf->Cell(0,8,utf8_decode($cotizacion->nombre_cliente),0,1,'L');
	$pdf->Ln(3);
	$pdf->SetFont('Arial','',10);
	$pdf->MultiCell(0,6,utf8_decode($configs['MensajeHeaderCotizacion']),0,'J');
	$pdf->Ln(5);
	
	/*Header Tabla*/
	$pdf->SetFont('Arial','B',9);
	$pdf->Cell(135,6,'Producto',1,0,'C');
	$pdf->Cell(20,6,'Cantidad',1,0,'C');
	$pdf->Cell(20,6,'Precio',1,0,'C');
	$pdf->Cell(20,6,'Total',1,1,'C');
	$pdf->SetFont('Arial','',9);
	foreach($productos as $producto){
		$pdf->Cell(135,6,utf8_decode($producto->desc_presentacion),1,0,'L');
		$pdf->Cell(20,6,$producto->cantidad_producto,1,0,'R');
		$pdf->Cell(20,6,$producto->precio_producto,1,0,'R');
		$pdf->Cell(20,6,number_format(($producto->cantidad_producto * $producto->precio_producto),2),1,1,'R');
	}
	$total = 0;
	if($cotizacion->subtotal_cotizacion > 0){
		$pdf->Cell(135,6,"",0,0,'L');
		$pdf->Cell(40,6,"Subtotal:",1,0,'L');
		$pdf->Cell(20,6,number_format($cotizacion->subtotal_cotizacion,2),1,1,'R');
		$total+=$cotizacion->subtotal_cotizacion;
	}
	if($cotizacion->iva_cotizacion > 0){
		$pdf->Cell(135,6,"",0,0,'L');
		$pdf->Cell(40,6,"IVA:",1,0,'L');
		$pdf->Cell(20,6,number_format($cotizacion->iva_cotizacion,2),1,1,'R');
		$total+=$cotizacion->iva_cotizacion;
	}
	if($cotizacion->retencion_cotizacion > 0){
		$pdf->Cell(135,6,"",0,0,'L');
		$pdf->Cell(40,6,"Retencion:",1,0,'L');
		$pdf->Cell(20,6,number_format($cotizacion->retencion_cotizacion,2),1,1,'R');
		$total+=$cotizacion->retencion_cotizacion;
	}
	if($cotizacion->percepcion_cotizacion > 0){
		$pdf->Cell(135,6,"",0,0,'L');
		$pdf->Cell(40,6,"Percepcion:",1,0,'L');
		$pdf->Cell(20,6,number_format($cotizacion->percepcion_cotizacion,2),1,1,'R');
		$total+=$cotizacion->percepcion_cotizacion;
	}
	if($cotizacion->total_nosujeto_cotizacion > 0){
		$pdf->Cell(135,6,"",0,0,'L');
		$pdf->Cell(40,6,"Total No Sujeto:",1,0,'L');
		$pdf->Cell(20,6,number_format($cotizacion->total_nosujeto_cotizacion,2),1,1,'R');
		$total+=$cotizacion->total_nosujeto_cotizacion;
	}
	if($cotizacion->total_exento_cotizacion > 0){
		$pdf->Cell(135,6,"",0,0,'L');
		$pdf->Cell(40,6,"Total Exento:",1,0,'L');
		$pdf->Cell(20,6,number_format($cotizacion->total_exento_cotizacion,2),1,1,'R');
		$total+=$cotizacion->total_exento_cotizacion;
	}
	
	$pdf->Cell(135,6,"",0,0,'L');
	$pdf->Cell(40,6,"Total:",1,0,'L');
	$pdf->Cell(20,6,number_format($total,2),1,1,'R');
	
	$pdf->Ln(5);
	
	if($cotizacion->notas_cotizacion != ""){
		$pdf->MultiCell(0,6,utf8_decode($cotizacion->notas_cotizacion),0,'J');
	}
	
	$pdf->MultiCell(0,6,utf8_decode($configs['MensajeFooterCotizacion']),0,'J');
	$pdf->Ln(5);
	
	if(filter_var($detalles_cotizacion['chequebool'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(50,6,utf8_decode("Cheque a nombre de"),0,0,'L');
		$pdf->Cell(145,6,utf8_decode($detalles_cotizacion['chequetext']),0,1,'L');
	endif;
	if(filter_var($detalles_cotizacion['preciosconiva'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(0,6,utf8_decode("Precios con IVA"),0,1,'L');
	endif;
	if(filter_var($detalles_cotizacion['validezbool'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(50,6,utf8_decode("Validez de la Oferta"),0,0,'L');
		$pdf->Cell(145,6,utf8_decode($detalles_cotizacion['valideztext']),0,1,'L');
	endif;
	if(filter_var($detalles_cotizacion['formapagobool'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(50,6,utf8_decode("Forma de Pago"),0,0,'L');
		$pdf->Cell(145,6,utf8_decode($detalles_cotizacion['formapagotext']),0,1,'L');
	endif;
	if(filter_var($detalles_cotizacion['periodobool'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(50,6,utf8_decode("Periodo de entrega"),0,0,'L');
		$pdf->Cell(145,6,utf8_decode($detalles_cotizacion['periodotext']),0,1,'L');
	endif;
	if(filter_var($detalles_cotizacion['observacionesbool'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(50,6,utf8_decode("Observaciones"),0,0,'L');
		$pdf->Cell(145,6,utf8_decode($detalles_cotizacion['observacionestext']),0,1,'L');
	endif;
	if(filter_var($detalles_cotizacion['garantiabool'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(50,6,utf8_decode("Garantia"),0,0,'L');
		$pdf->Cell(145,6,utf8_decode($detalles_cotizacion['garantiatext']),0,1,'L');
	endif;
	if(filter_var($detalles_cotizacion['precioscontrans'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(0,6,utf8_decode("Precios con Transporte"),0,1,'L');
	endif;
	if(filter_var($detalles_cotizacion['fletebool'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(50,6,utf8_decode("Flete"),0,0,'L');
		$pdf->Cell(145,6,utf8_decode($detalles_cotizacion['fletetext']),0,1,'L');
	endif;
	
	$pdf->Ln(20);	
	
	if(filter_var($detalles_cotizacion['firmacliente'], FILTER_VALIDATE_BOOLEAN)):
		$pdf->Cell(98,8,"F:___________________________________",0,0,'C');
		$pdf->Cell(98,8,"F:___________________________________",0,1,'C');
		$pdf->Cell(98,8,utf8_decode($cotizacion->firma_cotizacion),0,0,'C');
		$pdf->Cell(98,8,utf8_decode("Aceptado Cliente"),0,1,'C');
	else:
		$pdf->Cell(0,8,"F:___________________________________",0,1,'C');
		$pdf->Cell(0,8,utf8_decode($cotizacion->firma_cotizacion),0,1,'C');
	endif;	
	
    /*Exportamos el PDF*/
    $pdf->Output('Cotizacion '.$cotizacion->nombre_cliente,'I');
	
	function TraducirMes($month){
		switch($month){
			case '01':
					return $mes = 'Enero';
				break;
			case '02':
					return $mes = 'Febrero';
				break;
			case '03':
					return $mes = 'Marzo';
				break;
			case '04':
					return $mes = 'Abril';
				break;
			case '05':
					return $mes = 'Mayo';
				break;
			case '06':
					return $mes = 'Junio';
				break;
			case '07':
					return $mes = 'Julio';
				break;
			case '08':
					return $mes = 'Agosto';
				break;
			case '09':
					return $mes = 'Septiembre';
				break;
			case '10':
					return $mes = 'Octubre';
				break;
			case '11':
					return $mes = 'Noviembre';
				break;
			case '12':
					return $mes = 'Diciembre';
				break;
		}
	}
?>