<div class="row">
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Ventas</h5>
				<div class="ibox-tools">
					<a class="collapse-link">
						<i class="fa fa-chevron-up"></i>
					</a>
				</div>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row"><!--Ventas-->
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-venta-tipo">
									<option value='mensual'>Mensual</option>
									<option value='diario'>Diario</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-venta-desde-month" readonly>
								<input type="text" class="form-control" id="reportes-venta-desde-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-venta-hasta-month" readonly>
								<input type="text" class="form-control" id="reportes-venta-hasta-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-venta-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoVentas">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="ventas-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
	<!---->
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Utilidades</h5>
				<div class="ibox-tools">
					<a class="collapse-link">
						<i class="fa fa-chevron-up"></i>
					</a>
				</div>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row"><!--Utilidades-->
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-utilidad-tipo">
									<option value='mensual'>Mensual</option>
									<option value='diario'>Diario</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-utilidad-desde-month" readonly>
								<input type="text" class="form-control" id="reportes-utilidad-desde-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-utilidad-hasta-month" readonly>
								<input type="text" class="form-control" id="reportes-utilidad-hasta-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-utilidad-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoUtilidades">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="utilidades-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
<!--</div>
<div class="row">-->
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Ventas por linea</h5>
				<div class="ibox-tools">
					<a class="collapse-link">
						<i class="fa fa-chevron-up"></i>
					</a>
				</div>
			</div>
			<div class="ibox-content">
				<div class="row"><!--Ventas x lineas-->
					<div class="col-lg-12">
						<div class="row">
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-ventasxlineas-desde-days" readonly>
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-ventasxlineas-hasta-days" readonly>
							</div>
							<div class="col-sm-3">
								<label>Tipo de Grafico</label>
								<select class="form-control" id="reportes-ventasxlineas-tipo">
									<option value='pastel'>Pastel</option>
									<option value='barras'>Barras</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-ventasxlineas-mostrar" checked>
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoLineas">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="lineas-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
	<!---->
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Ventas por vendedor</h5>
				<div class="ibox-tools">
					<a class="collapse-link">
						<i class="fa fa-chevron-up"></i>
					</a>
				</div>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row"><!--Ventas-->
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-vendedor-tipo">
									<option value='mensual'>Mensual</option>
									<option value='diario'>Diario</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-vendedor-desde-month" readonly>
								<input type="text" class="form-control" id="reportes-vendedor-desde-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-vendedor-hasta-month" readonly>
								<input type="text" class="form-control" id="reportes-vendedor-hasta-days" readonly style="display:none;">
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-vendedor-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoVendedor">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="vendedor-ajax-content" style="height:375px;">
				</div>
			</div>
		</div>
	</div>
	
<!--</div>
<div class="row">-->
	<div class="col-lg-6">
		<div class="ibox float-e-margins">
			<div class="ibox-title">
				<h5>Productos estrellas</h5>
				<div class="ibox-tools">
					<a class="collapse-link">
						<i class="fa fa-chevron-up"></i>
					</a>
				</div>
			</div>
			<div class="ibox-content">
				<div class="row">
					<div class="col-lg-12">
						<div class="row">
							<div class="col-sm-3">
								<label>Tipo</label>
								<select class="form-control" id="reportes-pestrellas-tipo">
									<option value='numero'>Por Numero</option>
									<option value='ingresos'>Por Ingresos</option>
								</select>
							</div>
							<div class="col-sm-2">
								<label>Desde</label>
								<input type="text" class="form-control" id="reportes-pestrellas-desde-days" readonly>
							</div>
							<div class="col-sm-2">
								<label>Hasta</label>
								<input type="text" class="form-control" id="reportes-pestrellas-hasta-days" readonly>
							</div>
							<div class="col-sm-2">
								<label>Con Valores</label>
								<input type="checkbox" class="i-checks" id="reportes-pestrellas-mostrar">
							</div>
							<div class="col-sm-3">
								<button class="btn btn-info m-t-md" id="construirGraficoProductos">Construir</button>
							</div>
						</div>
					</div>
				</div>
				<div class="hr-line-dashed"></div>
				<div class="productos-ajax-content" style="height:375px;">
					
				</div>
			</div>
		</div>
	</div>
	<!---->
</div>
<script>
$(document).ready(function(){
	$('.i-checks').iCheck({
		checkboxClass: 'icheckbox_square-green',
		radioClass: 'iradio_square-green',
	});
	
	/*Ventas*/
	$("#construirGraficoVentas").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-venta-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-venta-tipo').val()=='mensual'){
			if($('#reportes-venta-desde-month').val() == ""){
				$('#reportes-venta-desde-month').focus();
				valid = false;
			}else if($('#reportes-venta-hasta-month').val() == ""){
				$('#reportes-venta-hasta-month').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-venta-desde-month').val();
				fechahasta = $('#reportes-venta-hasta-month').val();
			}
		}else{
			if($('#reportes-venta-desde-days').val() == ""){
				$('#reportes-venta-desde-days').focus();
				valid = false;
			}else if($('#reportes-venta-hasta-days').val() == ""){
				$('#reportes-venta-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-venta-desde-days').val();
				fechahasta = $('#reportes-venta-hasta-days').val();
			}
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_ventas?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-venta-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.ventas-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	$('#reportes-venta-tipo').change(function(){
		if($(this).val()=='mensual'){
			$('#reportes-venta-desde-month, #reportes-venta-hasta-month').val('');
			$('#reportes-venta-desde-days, #reportes-venta-hasta-days').val('');
			
			$('#reportes-venta-desde-month, #reportes-venta-hasta-month').show();
			$('#reportes-venta-desde-days, #reportes-venta-hasta-days').hide();
		}else{
			$('#reportes-venta-desde-month, #reportes-venta-hasta-month').val('');
			$('#reportes-venta-desde-days, #reportes-venta-hasta-days').val('');
			
			$('#reportes-venta-desde-month, #reportes-venta-hasta-month').hide();
			$('#reportes-venta-desde-days, #reportes-venta-hasta-days').show();
		}
	});
	$('#reportes-venta-desde-month, #reportes-venta-hasta-month').datepicker({
		language:'es',
		autoclose:true,
		format: "yyyy-mm", 
		startView: "months", 
		minViewMode: "months" 
	});
	var inicio_venta_diario = $('#reportes-venta-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_venta_diario.datepicker("update", newDate);
			$('#reportes-venta-hasta-days')[0].focus();
	});
	var fin_venta_diario = $('#reportes-venta-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_venta_diario.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_venta_diario.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true

	}).on('changeDate', function (ev) {}); 
	
	/*Utilidades*/
	$("#construirGraficoUtilidades").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-utilidad-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-utilidad-tipo').val()=='mensual'){
			if($('#reportes-utilidad-desde-month').val() == ""){
				$('#reportes-utilidad-desde-month').focus();
				valid = false;
			}else if($('#reportes-utilidad-hasta-month').val() == ""){
				$('#reportes-utilidad-hasta-month').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-utilidad-desde-month').val();
				fechahasta = $('#reportes-utilidad-hasta-month').val();
			}
		}else{
			if($('#reportes-utilidad-desde-days').val() == ""){
				$('#reportes-utilidad-desde-days').focus();
				valid = false;
			}else if($('#reportes-utilidad-hasta-days').val() == ""){
				$('#reportes-utilidad-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-utilidad-desde-days').val();
				fechahasta = $('#reportes-utilidad-hasta-days').val();
			}
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_utilidades?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-utilidad-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.utilidades-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	$('#reportes-utilidad-tipo').change(function(){
		if($(this).val()=='mensual'){
			$('#reportes-utilidad-desde-month, #reportes-utilidad-hasta-month').val('');
			$('#reportes-utilidad-desde-days, #reportes-utilidad-hasta-days').val('');
			
			$('#reportes-utilidad-desde-month, #reportes-utilidad-hasta-month').show();
			$('#reportes-utilidad-desde-days, #reportes-utilidad-hasta-days').hide();
		}else{
			$('#reportes-utilidad-desde-month, #reportes-utilidad-hasta-month').val('');
			$('#reportes-utilidad-desde-days, #reportes-utilidad-hasta-days').val('');
			
			$('#reportes-utilidad-desde-month, #reportes-utilidad-hasta-month').hide();
			$('#reportes-utilidad-desde-days, #reportes-utilidad-hasta-days').show();
		}
	});
	$('#reportes-utilidad-desde-month, #reportes-utilidad-hasta-month').datepicker({
		language:'es',
		autoclose:true,
		format: "yyyy-mm", 
		startView: "months", 
		minViewMode: "months" 
	});
	var inicio_utilidad_diario = $('#reportes-utilidad-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_utilidad_diario.datepicker("update", newDate);
			$('#reportes-utilidad-hasta-days')[0].focus();
	});
	var fin_utilidad_diario = $('#reportes-utilidad-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_utilidad_diario.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_utilidad_diario.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true
	});
	
	/*Ventas por linea*/
	$("#construirGraficoLineas").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-ventasxlineas-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-ventasxlineas-desde-days').val() == ""){
			$('#reportes-ventasxlineas-desde-days').focus();
			valid = false;
		}else if($('#reportes-ventasxlineas-hasta-days').val() == ""){
			$('#reportes-ventasxlineas-hasta-days').focus();
			valid = false;
		}else{
			fechadesde = $('#reportes-ventasxlineas-desde-days').val();
			fechahasta = $('#reportes-ventasxlineas-hasta-days').val();
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_lineas?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$("#reportes-ventasxlineas-tipo").val()+'&valores='+valores)
			.done(function(data){                
				$('.lineas-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	var inicio_venta_linea= $('#reportes-ventasxlineas-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_venta_linea.datepicker("update", newDate);
			$('#reportes-ventasxlineas-hasta-days')[0].focus();
	});
	var fin_venta_linea = $('#reportes-ventasxlineas-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_venta_linea.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_venta_linea.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true
	});
	
	/*Ventas por vendedor*/
	$("#construirGraficoVendedor").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-vendedor-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-vendedor-tipo').val()=='mensual'){
			if($('#reportes-vendedor-desde-month').val() == ""){
				$('#reportes-vendedor-desde-month').focus();
				valid = false;
			}else if($('#reportes-vendedor-hasta-month').val() == ""){
				$('#reportes-vendedor-hasta-month').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-vendedor-desde-month').val();
				fechahasta = $('#reportes-vendedor-hasta-month').val();
			}
		}else{
			if($('#reportes-vendedor-desde-days').val() == ""){
				$('#reportes-vendedor-desde-days').focus();
				valid = false;
			}else if($('#reportes-vendedor-hasta-days').val() == ""){
				$('#reportes-vendedor-hasta-days').focus();
				valid = false;
			}else{
				fechadesde = $('#reportes-vendedor-desde-days').val();
				fechahasta = $('#reportes-vendedor-hasta-days').val();
			}
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_ventas_vendedor?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-vendedor-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.vendedor-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	$('#reportes-vendedor-tipo').change(function(){
		if($(this).val()=='mensual'){
			$('#reportes-vendedor-desde-month, #reportes-vendedor-hasta-month').val('');
			$('#reportes-vendedor-desde-days, #reportes-vendedor-hasta-days').val('');
			
			$('#reportes-vendedor-desde-month, #reportes-vendedor-hasta-month').show();
			$('#reportes-vendedor-desde-days, #reportes-vendedor-hasta-days').hide();
		}else{
			$('#reportes-vendedor-desde-month, #reportes-vendedor-hasta-month').val('');
			$('#reportes-vendedor-desde-days, #reportes-vendedor-hasta-days').val('');
			
			$('#reportes-vendedor-desde-month, #reportes-vendedor-hasta-month').hide();
			$('#reportes-vendedor-desde-days, #reportes-vendedor-hasta-days').show();
		}
	});
	$('#reportes-vendedor-desde-month, #reportes-vendedor-hasta-month').datepicker({
		language:'es',
		autoclose:true,
		format: "yyyy-mm", 
		startView: "months", 
		minViewMode: "months" 
	});
	var inicio_vendedor_diario = $('#reportes-vendedor-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_vendedor_diario.datepicker("update", newDate);
			$('#reportes-vendedor-hasta-days')[0].focus();
	});
	var fin_vendedor_diario = $('#reportes-vendedor-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_vendedor_diario.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_vendedor_diario.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true

	}).on('changeDate', function (ev) {}); 
	
	/*Productos estrellas*/
	$("#construirGraficoProductos").on("click",function(){
		var valid = true;
		var fechadesde = "";
		var fechahasta = "";
		var valores = false;
		
		if($("#reportes-pestrellas-mostrar").is(":checked")){
			valores = true;
		}
		
		if($('#reportes-pestrellas-desde-days').val() == ""){
			$('#reportes-pestrellas-desde-days').focus();
			valid = false;
		}else if($('#reportes-pestrellas-hasta-days').val() == ""){
			$('#reportes-pestrellas-hasta-days').focus();
			valid = false;
		}else{
			fechadesde = $('#reportes-pestrellas-desde-days').val();
			fechahasta = $('#reportes-pestrellas-hasta-days').val();
		}
		if(valid){
			$.get('<?php echo base_url();?>reportes/grafico_productos_estrellas?fechadesde='+fechadesde+'&fechahasta='+fechahasta+'&tipo='+$('#reportes-pestrellas-tipo').val()+'&valores='+valores)
			.done(function(data){                
				$('.productos-ajax-content').html(data);
			});
		}else{
			toastr.options = {
			  "closeButton": true,
			  "progressBar": true,
			  "positionClass": "toast-top-right"
			}
			toastr.error('Hace falta informacion necesaria para enviar el formulario, favor verifique');
		}		
	});
	
	var inicio_pestrellas= $('#reportes-pestrellas-desde-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		autoclose:true
	}).on('changeDate', function (ev) {
			var newDate = new Date(ev.date);
			newDate.setDate(newDate.getDate());
			fin_pestrellas.datepicker("update", newDate);
			$('#reportes-pestrellas-hasta-days')[0].focus();
	});
	var fin_pestrellas = $('#reportes-pestrellas-hasta-days').datepicker({
		language:'es',
		format:'yyyy-mm-dd',
		beforeShowDay: function (date) {
			if (!inicio_pestrellas.datepicker("getDate").valueOf()) {
				return date.valueOf() >= new Date().valueOf();
			} else {
				return date.valueOf() > inicio_pestrellas.datepicker("getDate").valueOf()-1;
			}
		},
		autoclose: true
	});
	
	// Radialize the colors
	Highcharts.getOptions().colors = Highcharts.map(Highcharts.getOptions().colors, function (color) {
		return {
			radialGradient: {
				cx: 0.5,
				cy: 0.3,
				r: 0.7
			},
			stops: [
				[0, color],
				[1, Highcharts.Color(color).brighten(-0.3).get('rgb')] // darken
			]
		};
	});
});
</script>