﻿<?php
class Productos extends CI_Controller{
	function __construct(){
		parent::__construct();
		$this->is_logged_in();
		$this->session_ = $this->session->userdata('userInfo');
		$this->permisos=$this->Generic_model->get('usuarios','permisos_usuario',array('id_usuario'=>$this->session_['userid']));
		$this->permisos=unserialize(base64_decode($this->permisos[0]->permisos_usuario));
		/*usuario*/
		$this->usuario=$this->Generic_model->get('usuarios','nombre_usuario as nombre,username_usuario as username, thumb_usuario as thumbnail',array('id_usuario'=>$this->session_['userid']));
		$this->usuario=$this->usuario[0];
	}
	/**/
	function index(){echo "Productos!";}
	/*------------------------- INVENTARIOS ----------------------*/
	function autosku(){
		$configuraciones=$this->Generic_model->get("configuraciones","valor_config as correlativo",array("campo_config"=>"correlativo_sku_auto"));
		if(count($configuraciones)){
			echo $configuraciones[0]->correlativo;
		}else{
			echo 0;
		}
	}
	function inventario(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']="Inventario";
		if(!filter_var($this->permisos['inventario']['inventario-productos-ver'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
		}else{
			$UIData['main_view']="productos_inventario_view";
			$UIData['jsfiles']=array("miracle.productos","miracle.productos_inventario_nuevo_producto_view","miracle.productos_inventario_productos_kardex");
			$UIData['plugins']=array(
				array(
					"nombre"=>"datatables",
					"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
					"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
				),
				array(
					"nombre"=>"chosen",
					"css"=> array('chosen'),
					"js"=> array('chosen.jquery')
				),
				array(
					"nombre"=>"jquery_form",
					"js"=> array('jquery.form.min')
				),
				array(
					"nombre"=>"iCheck",
					"css"=>array('custom'),
					"js"=>array('icheck.min')
				),
				array(
					"nombre"=>"datapicker",
					"css"=>array('datepicker3'),
					"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
				),
			);
			$UIData['tiempo'] = $this->timequery();
			if($producto = $this->Generic_model->get('productos')){
				$UIData['tiempo'] = $this->timequery();
				$UIData['producto'] = count($producto);			
			}else{
				$UIData['tiempo'] = $this->timequery();
				$UIData['producto'] = 0;			
			}
			$UIData['permisos_reporteinventario']=filter_var($this->permisos['inventario']['inventario-productos-exportar-inventario'],FILTER_VALIDATE_BOOLEAN);
			$UIData['permisos_reportecatalogo']=filter_var($this->permisos['inventario']['inventario-productos-exportar-catalogo'],FILTER_VALIDATE_BOOLEAN);
		}
		$this->load->view('template', $UIData);
		
	}
		function cargar_inventario(){
			$this->load->library("ssp");
			$table = 'productos';
			$primaryKey = 'id_producto';
			$columns = array(
				array(
					'db' => '`pp`.`sku_presentacion`',
					'dt' => 0,
					'field' => 'sku_presentacion',
					'formatter' => function( $d, $row ) {
						return strtoupper($d);
					}
				),
				array(
					'db' => '`pp`.`desc_presentacion`',
					'dt' => 1, 'field' => 'desc_presentacion',
					'formatter' => function( $d, $row ) {
						return strtoupper($d);
					}					
				),
				array( 'db' => '`p`.`exist_act_producto`', 'dt' => 2, 'field' => 'exist_act_producto' ),
				array(
					'db' => '`p`.`exist_act_producto`',
					'dt' => 3,
					'field' => 'exist_act_producto',
					'formatter' => function( $d, $row ) {
						if($d <= 0){
							return '<span class="badge badge-danger">Agotado</span>';
						}else if($d > 0 && $d <= $row[5]){
							return '<span class="badge badge-warning">Minimas</span>';
						}else if($d >= $row[6] && $row[6] != 0){
							return '<span class="label label-success">Maximas</span>';
						}else{
							return '<span class="badge badge-info">Ok</span>';							
						}
					}
				),
				array( 'db' => '`p`.`exist_min_producto`', 'dt' => 4, 'field' => 'exist_min_producto' ),
				array( 'db' => '`p`.`exist_max_producto`', 'dt' => 5, 'field' => 'exist_max_producto' ),
				array( 'db' => '`p`.`id_producto`', 'dt' => 6, 'field' => 'id_producto' ),
			);
			$host =  explode(':',$this->db->hostname);
			$sql_details = array(
				'user' => $this->db->username,
				'pass' => $this->db->password,
				'db'   => $this->db->database,
				'host' => $host[0]
			);
			$joinQuery = "FROM `productos` AS `p` LEFT OUTER JOIN `presentaciones` AS `pp` ON (`pp`.`id_producto` = `p`.`id_producto`)";
			$extraWhere = "`pp`.`tipo_presentacion` = 0";
			$groupBy = '';
			echo json_encode(
				$this->ssp->simple( $this->input->post(), $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere,$groupBy)
			);
		}
		function ver_producto(){
			$wheres = array('id_producto' => $this->input->get('id'));
			$joins = array(
				'grupos' => 'grupos.id_grupo = productos.id_grupo,left outer',
				'subgrupos' => 'subgrupos.id_subgrupo = productos.id_subgrupo,left outer',
				'ubicaciones' => 'ubicaciones.id_ubicacion = productos.ubicacion_producto,left outer',
				'unidades' => 'unidades.id_unidad = productos.unidad_medida_producto,left outer',
			);
			/*Producto*/
			$producto=$this->Generic_model->get('productos','*',$wheres,$orders = "",$likes="",$joins);
			/*Presentacion primaria'*/
			$presentacionPrim=$this->Generic_model->get('presentaciones','*',array('id_producto'=>$this->input->get('id'),'tipo_presentacion'=>0),'','','',1);
			$presentacionPrim=$presentacionPrim[0];
			$presentacionPrim->precios=$this->Generic_model->get('preciosxpresentacion','*',array('id_presentacion'=>$presentacionPrim->id_presentacion),array("precio_identificador"=>"ASC"));
			/*Presentaciones secundarias*/
			$_presentaciones=$this->Generic_model->get('presentaciones','*',array('id_producto'=>$this->input->get('id'),'tipo_presentacion !='=>0));
			$presentaciones=array();
			if(count($_presentaciones)>0){
				foreach($_presentaciones as $presentacion){
					$presentaciones[]=array(
						'id'=>$presentacion->id_presentacion,
						'sku'=>$presentacion->sku_presentacion,
						'desc'=>$presentacion->desc_presentacion,
						'uequiv'=>$presentacion->unidades_representativas,
						'precios'=>$this->Generic_model->get('preciosxpresentacion','*',array('id_presentacion'=>$presentacion->id_presentacion))
					);
				}
			}
			$data['producto'] = $producto[0];
			$data['presentacionPrimaria'] = $presentacionPrim;
			$data['presentaciones'] = $presentaciones;
			/*Permisos*/
			$data['permisos_precio1']=filter_var($this->permisos['facturacion']['transacciones-precio1-ver'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_precio2']=filter_var($this->permisos['facturacion']['transacciones-precio2-ver'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_precio3']=filter_var($this->permisos['facturacion']['transacciones-precio3-ver'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_precio4']=filter_var($this->permisos['facturacion']['transacciones-precio4-ver'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_precio5']=filter_var($this->permisos['facturacion']['transacciones-precio5-ver'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_precio6']=filter_var($this->permisos['facturacion']['transacciones-precio6-ver'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_editar']=filter_var($this->permisos['inventario']['inventario-productos-editar'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_eliminar']=filter_var($this->permisos['inventario']['inventario-productos-eliminar'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_kardex']=filter_var($this->permisos['inventario']['inventario-productos-kardex'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_utilidad']=filter_var($this->permisos['inventario']['inventario-productos-utilidad'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_coma']=filter_var($this->permisos['inventario']['inventario-productos-coma'],FILTER_VALIDATE_BOOLEAN);
			$data['permisos_comi']=filter_var($this->permisos['inventario']['inventario-productos-comi'],FILTER_VALIDATE_BOOLEAN);
			/*--------------- COSTO ------------*/
			$costo_promedio_producto="N/A";
			$costo_ultimacompra_producto="N/A";
			/*Obtener TODAS las transacciones*/
			$sqlStmt="(SELECT  'entrada' as trans, id_entrada as id,fecha_entrada as fecha,concepto_entrada as concepto,(cant_entrada*unidades_representativas) as entrada, '0' as salida,(costo_entrada/unidades_representativas) as costo, ventas.documento_venta as documentov, resoluciones_caja.serie_autorizada as seriev, ventas.num_documento_venta as numdocv, 0 as venta FROM entrada_productos LEFT JOIN devoluciones ON entrada_productos.id_devolucion=devoluciones.id_devolucion LEFT JOIN ventas ON devoluciones.id_venta=ventas.id_venta LEFT JOIN resoluciones_caja ON ventas.id_resolucion=resoluciones_caja.id_resolucion LEFT JOIN presentaciones ON presentaciones.id_presentacion=entrada_productos.id_presentacion WHERE entrada_productos.id_producto = '". $this->input->get('id')."')";
			$sqlStmt.=" UNION ALL "; 
			$sqlStmt.="(SELECT  'salida' as trans,id_salida as id,fecha_salida as fecha,concepto_salida as concepto,'0' as entrada,(cant_salida*unidades_representativas) as salida,0 as costo, ventas.documento_venta as  documentov, resoluciones_caja.serie_autorizada as seriev, ventas.num_documento_venta as numdocv, salida_productos.id_venta as venta FROM salida_productos LEFT JOIN ventas ON salida_productos.id_venta=ventas.id_venta LEFT JOIN resoluciones_caja ON ventas.id_resolucion=resoluciones_caja.id_resolucion LEFT JOIN presentaciones ON presentaciones.id_presentacion=salida_productos.id_presentacion WHERE salida_productos.id_producto = '".$this->input->get('id')."')";
			$sqlStmt.=" ORDER BY fecha"; 
			$trans=$this->Generic_model->sql_custom($sqlStmt);
			if(count($trans)){
				$total_entradas_producto=0;
				$total_salidas_producto=0;
				$costo_promedio_producto=0;
				$costos_compra_totales_producto=0;
				$cantidad_compra_totales_producto=0;
				$primera_entrada=true;
				foreach($trans as $tran){
					$total_entradas_producto+=$tran->entrada;
					$total_salidas_producto+=$tran->salida;
					$total_existencia_producto=$total_entradas_producto-$total_salidas_producto;
					/*Calculo del coste*/
					if($tran->trans=='entrada'){
						if($primera_entrada){
							$primera_entrada=false;
							if($tran->concepto==1 || $tran->concepto==0  || $tran->concepto==9){ /*primera entrada*/
								$costo_promedio_producto=$tran->costo;
								$costo_ultimacompra_producto=$tran->costo;
							}
						}else{
							if($tran->concepto==1){ /*Compras*/
								$costo_total_anterior=($total_existencia_producto-$tran->entrada)*$costo_promedio_producto;
								$costo_transaccion_actual=$tran->costo*$tran->entrada;
								if($total_existencia_producto>0){
									$costo_promedio_producto=($costo_total_anterior+$costo_transaccion_actual)/$total_existencia_producto;
								}
								$costo_ultimacompra_producto=$tran->costo;
							}
						}	
					}
				}
			}
			$data['costo_promedio']=$costo_promedio_producto;
			$data['costo_ultimacompra']=$costo_ultimacompra_producto;
		
			$this->load->view('productos_inventario_detalles_producto_view',$data);
		}
		function presentaciones_detalles(){
			$wheres = array('id_producto' => $this->input->get('id'));
			$joins = array(
				'grupos' => 'grupos.id_grupo = productos.id_grupo,left outer',
				'subgrupos' => 'subgrupos.id_subgrupo = productos.id_subgrupo,left outer'
			);
			/*Producto*/
			$producto=$this->Generic_model->get('productos','*',$wheres,$orders = "",$likes="",$joins);
			$presentacionPrim=$this->Generic_model->get('presentaciones','*',array('id_producto'=>$this->input->get('id'),'tipo_presentacion'=>0),'','','',1);
			$_presentaciones=$this->Generic_model->get('presentaciones','*',array('id_producto'=>$this->input->get('id'),'tipo_presentacion !='=>0));
			$presentaciones=array();
			if(count($_presentaciones)>0){
				foreach($_presentaciones as $presentacion){
					$presentaciones[]=array(
						'id'=>$presentacion->id_presentacion,
						'sku'=>$presentacion->sku_presentacion,
						'desc'=>$presentacion->desc_presentacion,
						'uequiv'=>$presentacion->unidades_representativas,
						'precios'=>$this->Generic_model->get('preciosxpresentacion','*',array('id_presentacion'=>$presentacion->id_presentacion),array("precio_identificador"=>"ASC"))
					);
				}
			}
			$UIDataModal['producto'] = $producto[0];
			$UIDataModal['presentacionPrimaria'] = $presentacionPrim[0];
			$UIDataModal['presentaciones'] = $presentaciones;
			$UIDataModal["content_view"] =  "productos_inventario_productos_presentaciones_detalles_view";
			$UIDataModal["title"] = "Detalles de presentaciones";
			$UIDataModal["close_button"] = true;
			$UIDataModal["classes"] = "modal-lg";
			$UIDataModal["id"] = "inventario-producto-presentaciones-detalles-modal";
			/*Permisos*/
			$UIDataModal['permisos_precio1']=filter_var($this->permisos['facturacion']['transacciones-precio1-ver'],FILTER_VALIDATE_BOOLEAN);
			$UIDataModal['permisos_precio2']=filter_var($this->permisos['facturacion']['transacciones-precio2-ver'],FILTER_VALIDATE_BOOLEAN);
			$UIDataModal['permisos_precio3']=filter_var($this->permisos['facturacion']['transacciones-precio3-ver'],FILTER_VALIDATE_BOOLEAN);
			$UIDataModal['permisos_precio4']=filter_var($this->permisos['facturacion']['transacciones-precio4-ver'],FILTER_VALIDATE_BOOLEAN);
			$UIDataModal['permisos_precio5']=filter_var($this->permisos['facturacion']['transacciones-precio5-ver'],FILTER_VALIDATE_BOOLEAN);
			$UIDataModal['permisos_precio6']=filter_var($this->permisos['facturacion']['transacciones-precio6-ver'],FILTER_VALIDATE_BOOLEAN);
			$UIDataModal['permisos_utilidad']=filter_var($this->permisos['inventario']['inventario-productos-utilidad'],FILTER_VALIDATE_BOOLEAN);
			$UIDataModal['permisos_coma']=filter_var($this->permisos['inventario']['inventario-productos-coma'],FILTER_VALIDATE_BOOLEAN);
			$UIDataModal['permisos_comi']=filter_var($this->permisos['inventario']['inventario-productos-comi'],FILTER_VALIDATE_BOOLEAN);
			/**/
			$this->load->view('template_modal',$UIDataModal); 
		}
		/**/
		function kardex(){
			$UIDataModal["content_view"]="productos_inventario_productos_kardex_view";
			$UIDataModal["title"] = "Kardex de producto";
			$UIDataModal["close_button"] = true;
			$UIDataModal["classes"] = "modal-lg";
			$UIDataModal["id"] = "inventario-producto-kardex-modal";
			$UIDataModal["producto"] =$this->input->get("id");
			
			
			$this->load->view('template_modal',$UIDataModal); 
		}
		function generarkardex(){
			$inicio=null;
			$final=null;
			$producto=$this->input->get("id");
			if($this->input->get("inicio") && $this->input->get("inicio")!=""){
				$inicio = date("Y-m-d H:i:s", strtotime($this->input->get("inicio")));
			}
			if($this->input->get("fin") && $this->input->get("fin")!=""){
				$finaldate=$this->input->get("fin")." 23:59:59";
				$final = date("Y-m-d H:i:s", strtotime($finaldate));
			}
			
			if($final)
				$sqlStmt="(SELECT  'entrada' as trans, id_entrada as id,fecha_entrada as fecha,concepto_entrada as concepto,(cant_entrada*unidades_representativas) as entrada, '0' as salida, ventas.documento_venta as documentov, resoluciones_caja.serie_autorizada as seriev, ventas.num_documento_venta as numdocv FROM entrada_productos JOIN presentaciones ON presentaciones.id_presentacion=entrada_productos.id_presentacion LEFT JOIN devoluciones ON entrada_productos.id_devolucion=devoluciones.id_devolucion LEFT JOIN ventas ON devoluciones.id_venta=ventas.id_venta LEFT JOIN resoluciones_caja ON ventas.id_resolucion=resoluciones_caja.id_resolucion WHERE entrada_productos.id_producto = '". $producto. "' AND fecha_entrada < '".$final."')";
			else
				$sqlStmt="(SELECT  'entrada' as trans, id_entrada as id,fecha_entrada as fecha,concepto_entrada as concepto,(cant_entrada*unidades_representativas) as entrada, '0' as salida, ventas.documento_venta as documentov, resoluciones_caja.serie_autorizada as seriev, ventas.num_documento_venta as numdocv FROM entrada_productos JOIN presentaciones ON presentaciones.id_presentacion=entrada_productos.id_presentacion LEFT JOIN devoluciones ON entrada_productos.id_devolucion=devoluciones.id_devolucion LEFT JOIN ventas ON devoluciones.id_venta=ventas.id_venta LEFT JOIN resoluciones_caja ON ventas.id_resolucion=resoluciones_caja.id_resolucion WHERE entrada_productos.id_producto = '". $producto. "')";
			$sqlStmt.=" UNION ALL "; 
			if($final)
				$sqlStmt.="(SELECT  'salida' as trans,id_salida as id,fecha_salida as fecha,concepto_salida as concepto,'0' as entrada, (cant_salida*unidades_representativas) as salida, ventas.documento_venta as  documentov, resoluciones_caja.serie_autorizada as seriev, ventas.num_documento_venta as numdocv  FROM salida_productos JOIN presentaciones ON presentaciones.id_presentacion=salida_productos.id_presentacion LEFT JOIN ventas ON salida_productos.id_venta=ventas.id_venta LEFT JOIN resoluciones_caja ON ventas.id_resolucion=resoluciones_caja.id_resolucion WHERE salida_productos.id_producto = '". $producto. "' AND fecha_salida < '".$final."')";
	 		else
				$sqlStmt.="(SELECT  'salida' as trans,id_salida as id,fecha_salida as fecha,concepto_salida as concepto,'0' as entrada, (cant_salida*unidades_representativas) as salida, ventas.documento_venta as  documentov, resoluciones_caja.serie_autorizada as seriev, ventas.num_documento_venta as numdocv FROM salida_productos JOIN presentaciones ON presentaciones.id_presentacion=salida_productos.id_presentacion LEFT JOIN ventas ON salida_productos.id_venta=ventas.id_venta LEFT JOIN resoluciones_caja ON ventas.id_resolucion=resoluciones_caja.id_resolucion WHERE salida_productos.id_producto = '". $producto. "')";
	 		
			$sqlStmt.=" ORDER BY fecha"; 
			$trans= $this->Generic_model->sql_custom($sqlStmt);
			
			if(count($trans)){
				$saldoInicial=0;
				$saldo=0;
				$inicialbroker=false;
				echo "<table class='table'>";
				echo "<thead><tr><th>ID transacci&oacute;n</th><th>fecha</th><th>Concepto</th><th>Entradas</th><th>Salidas</th><th>Saldo</th></tr></thead>";
				echo "<tbody>";
				foreach($trans as $tran){
					if($inicio && $tran->fecha < $inicio){
						$inicialbroker=true;
						$saldoInicial=$saldoInicial+$tran->entrada-$tran->salida;
					}else{
						if($inicialbroker){
							echo "<tr>";
							echo "<td> - </td>";
							echo "<td> - </td>";
							echo "<td>Existencias a la fecha</td>";
							echo "<td>-</td>";
							echo "<td>-</td>";
							echo "<td>".number_format($saldoInicial,4)."</td>";
							echo "</tr>";
							$saldo+=$saldoInicial;
							$inicialbroker=false;
						}
						$saldo=$saldo+$tran->entrada-$tran->salida;
						
						if($tran->trans=="entrada"){
							switch($tran->concepto){
								case 0:$tran->concepto="Inventario inicial";break;
								case 1:$tran->concepto="Compra";break;
								case 2:
									$docV="Desconocido";
									switch($tran->documentov){
										case 0:$docV="Ninguno";break; 
										case 1:$docV="Factura";break; 
										case 2:$docV="CCF";break; 
										case 3:$docV="Ticket";break; 
										case 4:$docV="Nota de remisión";break; 
										case 5:$docV="Nota de envío";break; 
									}
									$tran->concepto="Devoluci&oacute;n ".$docV." ".$tran->seriev." ".$tran->numdocv;
								break;
								case 9:$tran->concepto="Ajuste por conteo de inventario";break;
							}
						}
						if($tran->trans=="salida"){
							switch($tran->concepto){
								case 0:
									$docV="Desconocido";
									switch($tran->documentov){
										case 0:$docV="Ninguno";break; 
										case 1:$docV="Factura";break; 
										case 2:$docV="CCF";break; 
										case 3:$docV="Ticket";break; 
										case 4:$docV="Nota de remisión";break; 
										case 5:$docV="Nota de envío";break; 
									}
									$tran->concepto="Venta ".$docV." ".$tran->seriev." ".$tran->numdocv;
								break;
								case 1:$tran->concepto="Pedido";break;
								case 2:$tran->concepto="Daño o vencimiento";break;
								case 3:$tran->concepto="Perdida o extravio";break;
								case 4:$tran->concepto="Devoluci&oacute;n a proveedor";break;
								case 5:$tran->concepto="Consumo interno";break;
								case 7:$tran->concepto="Anulaci&oacute;n de compra";break;
								case 9:$tran->concepto="Ajuste por conteo de inventario";break;
							}
						}
						echo "<tr>";
						echo "<td>".$tran->id."</td>";
						echo "<td>".date("d/m/Y H:i:s",strtotime($tran->fecha))."</td>";
						echo "<td>".$tran->concepto."</td>";
						echo "<td>".number_format($tran->entrada,4)."</td>";
						echo "<td>".number_format($tran->salida,4)."</td>";
						echo "<td>".number_format($saldo,4)."</td>";
						echo "</tr>";
					}
				}
				echo "</tbody></table>";  
			}
			
		}
		function inventario_nuevo_producto(){	
			$ubicaciones=$this->Generic_model->get('ubicaciones');
			$unidades=$this->Generic_model->get('unidades');
			$UIDataModal['ubicaciones']=$ubicaciones;
			$UIDataModal['unidades']=$unidades;
			if($this->input->get('mode')=='edit'){ /*Editar producto*/
				$UIDataModal["title"] = "Editar producto";
				if(!filter_var($this->permisos['inventario']['inventario-productos-editar'],FILTER_VALIDATE_BOOLEAN)){
					$UIDataModal['content_view']="error_noacceso_view";
				}else{
					if($this->Generic_model->get("presentaciones","*","",array("sku_presentacion" => "desc"),"","",1)){
						$id_actual = $this->Generic_model->get("presentaciones","*","",array("sku_presentacion" => "desc"),"","",1);
						$UIDataModal["id_actual"] = $id_actual[0]->sku_presentacion + 1;
					}else{
						$UIDataModal["id_actual"] = 1;
					}
					if($this->input->get('id')){
						$wheres = array('productos.id_producto' => $this->input->get('id'),'prese.tipo_presentacion'=>0);
						$joins = array(
							'presentaciones prese' => 'prese.id_producto = productos.id_producto'
						);
						$producto = $this->Generic_model->get('productos','*',$wheres,$orders = "",$likes="",$joins);
						$presentacionPrim=$this->Generic_model->get('presentaciones','*',array('id_producto'=>$this->input->get('id'),'tipo_presentacion'=>0),'','','',1);
						$presentacionPrim=$presentacionPrim[0];
						$presentacionPrim->precios=$this->Generic_model->get('preciosxpresentacion','*',array('id_presentacion'=>$presentacionPrim->id_presentacion),array("precio_identificador"=>"ASC"));
						/*Presentaciones secundarias*/
						$_presentaciones=$this->Generic_model->get('presentaciones','*',array('id_producto'=>$this->input->get('id'),'tipo_presentacion !='=>0));
						$presentaciones=array();
						if(count($_presentaciones)>0){
							foreach($_presentaciones as $presentacion){
								$presentaciones[]=array(
									'id'=>$presentacion->id_presentacion,
									'sku'=>$presentacion->sku_presentacion,
									'desc'=>$presentacion->desc_presentacion,
									'uequiv'=>$presentacion->unidades_representativas,
									'precios'=>$this->Generic_model->get('preciosxpresentacion','*',array('id_presentacion'=>$presentacion->id_presentacion),array("precio_identificador"=>"ASC"))
								);
							}
						}
						$UIDataModal['producto']=$producto;
						$UIDataModal['presentacionPrimaria']=$presentacionPrim;
						$UIDataModal['presentaciones']=$presentaciones;
					}
					$grupos=$this->Generic_model->get('grupos');
					$UIDataModal['grupos'] = $grupos;
					$UIDataModal["content_view"] =  "productos_inventario_nuevo_producto_view";
					$UIDataModal["close_button"] = true;
					$UIDataModal["classes"] = "modal-lg";
					$UIDataModal["id"] = "inventario-nuevo-producto-modal";
				}
			}else{ /*nuevo producto*/
				$UIDataModal["title"] = "Nuevo producto";
				if(!filter_var($this->permisos['inventario']['inventario-productos-crear'],FILTER_VALIDATE_BOOLEAN)){
					$UIDataModal['content_view']="error_noacceso_view";
				}else{
					if($this->Generic_model->get("presentaciones","*","",array("sku_presentacion" => "desc"),"","",1)){
						$id_actual = $this->Generic_model->get("presentaciones","*","",array("sku_presentacion" => "desc"),"","",1);
						$UIDataModal["id_actual"] = $id_actual[0]->sku_presentacion + 1;
					}else{
						$UIDataModal["id_actual"] = 1;
					}
					if($this->input->get('id')){
						$wheres = array('productos.id_producto' => $this->input->get('id'),'prese.tipo_presentacion'=>0);
						$joins = array(
							'grupos' => 'grupos.id_grupo = productos.id_grupo,left outer',
							'subgrupos' => 'subgrupos.id_subgrupo = productos.id_subgrupo,left outer',
							'presentaciones prese' => 'prese.id_producto = productos.id_producto'
						);
						$producto = $this->Generic_model->get('productos','*',$wheres,$orders = "",$likes="",$joins);
						$presentacionPrim=$this->Generic_model->get('presentaciones','*',array('id_producto'=>$this->input->get('id'),'tipo_presentacion'=>0),'','','',1);
						$presentacionPrim=$presentacionPrim[0];
						$presentacionPrim->precios=$this->Generic_model->get('preciosxpresentacion','*',array('id_presentacion'=>$presentacionPrim->id_presentacion),array("precio_identificador"=>"ASC"));
						/*Presentaciones secundarias*/
						$_presentaciones=$this->Generic_model->get('presentaciones','*',array('id_producto'=>$this->input->get('id'),'tipo_presentacion !='=>0));
						$presentaciones=array();
						if(count($_presentaciones)>0){
							foreach($_presentaciones as $presentacion){
								$presentaciones[]=array(
									'id'=>$presentacion->id_presentacion,
									'sku'=>$presentacion->sku_presentacion,
									'desc'=>$presentacion->desc_presentacion,
									'uequiv'=>$presentacion->unidades_representativas,
									'precios'=>$this->Generic_model->get('preciosxpresentacion','*',array('id_presentacion'=>$presentacion->id_presentacion),array("precio_identificador"=>"ASC"))
								);
							}
						}
						$UIDataModal['producto']=$producto;
						$UIDataModal['presentacionPrimaria']=$presentacionPrim;
						$UIDataModal['presentaciones']=$presentaciones;
					}
					$grupos = $this->Generic_model->get('grupos');
					$UIDataModal['grupos'] = $grupos;
					$UIDataModal["content_view"] =  "productos_inventario_nuevo_producto_view";
					$UIDataModal["close_button"] = true;
					$UIDataModal["classes"] = "modal-lg";
					$UIDataModal["id"] = "inventario-nuevo-producto-modal";
				}
			}
			$this->load->view('template_modal',$UIDataModal); 
		}
		function guardar_producto(){
			$fecha=gmdate('Y-m-d H:i:s',strtotime('- 6 hours'));
			if($this->input->post('id_producto') != ''){
				if($this->input->post('imagen_producto') != ""){
					$imagen = $this->input->post('imagen_producto');
				}else{
					$imagen = "";
				}
			}else{
				$imagen = "";
			}
			
			if($this->input->post('sku_auto')==1){
				$configuraciones=$this->Generic_model->get("configuraciones","valor_config as correlativo",array("campo_config"=>"correlativo_sku_auto"));
				if(count($configuraciones)){
					$correlativo = $configuraciones[0]->correlativo;
				}
				
				$this->Generic_model->update('configuraciones',$data = array('valor_config' => $correlativo = $correlativo+1),'campo_config','correlativo_sku_auto');
			}
			
			$conf['upload_path'] = './upload_images/';
			$conf['allowed_types'] = 'gif|jpg|png';
			$conf['file_name'] = 'img-producto'.md5(date('Y-m-d h:m:s'));
			$this->load->library('upload', $conf);
			$this->upload->overwrite = true;
			if($this->upload->do_upload('nuevo-producto-img-file')){
				$uploadData = $this->upload->data();
				$imgPatch ='upload_images/'.$uploadData['orig_name'];
				$this->load->library('image_lib');
				$config['image_library'] = 'gd2';
				$config['source_image']  = $imgPatch;
				$config['maintain_ratio'] = TRUE;
				$config['height']    = 95;
				$config['width']    = 170;
				
				$this->image_lib->initialize($config);
				if($this->image_lib->resize()){
					$imagen = $imgPatch;
				}
			}else{
				$imagen = $imagen;
			}
			/*Grupo*/
			if($this->input->post('id_grupo') == ""){$grupo=null;}
			else{$grupo = $this->input->post('id_grupo');}
			/*Sub grupo*/
			if($this->input->post('id_sub_grupo') == ""){$subgrupo = null;
			}else{$subgrupo = $this->input->post('id_sub_grupo');}
			/*Producto*/
			$data = array(
				'tipo_producto'=>0,
				'id_grupo'=>$grupo,
				'id_subgrupo'=>$subgrupo,
				'exist_min_producto'=>$this->input->post('exist_min_producto'),
				'exist_max_producto'=>$this->input->post('exist_max_producto'),
				'tipo_venta'=>$this->input->post('tipo_venta_producto'),
				'info_producto'=>strtoupper($this->input->post('info_producto')),
				'ubicacion_producto'=>strtoupper($this->input->post('ubicacion_producto')),
				'unidad_medida_producto'=>$this->input->post('umedida_producto'),
				'imagen_producto'=>$imagen
			);
			
			if($this->input->post('id_producto') == ''){ /*Guardar*/
				$idproducto=$this->Generic_model->save('productos',$data,true);
			}else{/*Actualizar*/			
				$this->Generic_model->update('productos',$data,'id_producto',$this->input->post('id_producto'));
				$idproducto=$this->input->post('id_producto');
			}
			/*Presentaciones*/
			$presentaciones=json_decode($this->input->post('presentaciones_producto')); /*presentaciones enviadas*/
			$IDsWheres='';
			foreach($presentaciones as $presentacion){
				if($presentacion->tipo==0){
					$prodDesc=$presentacion->desc;
				}
				$presentacionData=array(
					'id_producto'=>$idproducto,
					'sku_presentacion'=>strtoupper($presentacion->sku),
					'desc_presentacion'=>strtoupper($presentacion->desc),
					'unidades_representativas'=>$presentacion->uquiv,
					'tipo_presentacion'=>$presentacion->tipo,
				);
				if($this->input->post('id_producto') == ''){ /*Guardar nueva presentaciones presentacion*/
					$presentacionId=$this->Generic_model->save('presentaciones',$presentacionData,true);
					/*Precios*/
					$preciosData=array();
					$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>1,'precio_presentacion'=>$presentacion->p1,'precio_porcentaje'=>$presentacion->pp1,'precio_autorizacion'=>filter_var(false,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p1cma,'comision_minorista'=>$presentacion->p1cmi);
					$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>2,'precio_presentacion'=>$presentacion->p2,'precio_porcentaje'=>$presentacion->pp2,'precio_autorizacion'=>filter_var($presentacion->p2au,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p2cma,'comision_minorista'=>$presentacion->p2cmi);
					$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>3,'precio_presentacion'=>$presentacion->p3,'precio_porcentaje'=>$presentacion->pp3,'precio_autorizacion'=>filter_var($presentacion->p3au,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p3cma,'comision_minorista'=>$presentacion->p3cmi);
					$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>4,'precio_presentacion'=>$presentacion->p4,'precio_porcentaje'=>$presentacion->pp4,'precio_autorizacion'=>filter_var($presentacion->p4au,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p4cma,'comision_minorista'=>$presentacion->p4cmi);
					$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>5,'precio_presentacion'=>$presentacion->p5,'precio_porcentaje'=>$presentacion->pp5,'precio_autorizacion'=>filter_var($presentacion->p5au,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p5cma,'comision_minorista'=>$presentacion->p5cmi);
					$this->Generic_model->savebatch('preciosxpresentacion',$preciosData);
				}else{/*EDITAR presentaciones*/
					if($presentacion->pre!=''){/*Modificar presentacion existente*/
						$this->Generic_model->update('presentaciones',$presentacionData,'id_presentacion',$presentacion->pre);
						
						$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$presentacion->p1,'precio_porcentaje'=>$presentacion->pp1,'precio_autorizacion'=>filter_var(false,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p1cma,'comision_minorista'=>$presentacion->p1cmi),array('id_presentacion'=>$presentacion->pre,'precio_identificador'=>1));
						$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$presentacion->p2,'precio_porcentaje'=>$presentacion->pp2,'precio_autorizacion'=>filter_var($presentacion->p2au,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p2cma,'comision_minorista'=>$presentacion->p2cmi),array('id_presentacion'=>$presentacion->pre,'precio_identificador'=>2));
						$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$presentacion->p3,'precio_porcentaje'=>$presentacion->pp3,'precio_autorizacion'=>filter_var($presentacion->p3au,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p3cma,'comision_minorista'=>$presentacion->p3cmi),array('id_presentacion'=>$presentacion->pre,'precio_identificador'=>3));
						$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$presentacion->p4,'precio_porcentaje'=>$presentacion->pp4,'precio_autorizacion'=>filter_var($presentacion->p4au,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p4cma,'comision_minorista'=>$presentacion->p4cmi),array('id_presentacion'=>$presentacion->pre,'precio_identificador'=>4));
						$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$presentacion->p5,'precio_porcentaje'=>$presentacion->pp5,'precio_autorizacion'=>filter_var($presentacion->p5au,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>$presentacion->p5cma,'comision_minorista'=>$presentacion->p5cmi),array('id_presentacion'=>$presentacion->pre,'precio_identificador'=>5));
						$IDsWheres.=" AND id_presentacion != ".$presentacion->pre;
					}else{/*Agregar nuevas presentaciones*/
						$presentacionId=$this->Generic_model->save('presentaciones',$presentacionData,true);
						$preciosData=array();
						$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>1,'precio_presentacion'=>$presentacion->p1,'precio_porcentaje'=>$presentacion->p1,'precio_autorizacion'=>filter_var(false,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>NULL,'comision_minorista'=>NULL);
						$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>2,'precio_presentacion'=>$presentacion->p2,'precio_porcentaje'=>$presentacion->p2,'precio_autorizacion'=>filter_var(false,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>NULL,'comision_minorista'=>NULL);
						$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>3,'precio_presentacion'=>$presentacion->p3,'precio_porcentaje'=>$presentacion->p3,'precio_autorizacion'=>filter_var(false,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>NULL,'comision_minorista'=>NULL);
						$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>4,'precio_presentacion'=>$presentacion->p4,'precio_porcentaje'=>$presentacion->p4,'precio_autorizacion'=>filter_var(false,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>NULL,'comision_minorista'=>NULL);
						$preciosData[]=array('id_presentacion'=>$presentacionId,'precio_identificador'=>5,'precio_presentacion'=>$presentacion->p5,'precio_porcentaje'=>$presentacion->p5,'precio_autorizacion'=>filter_var(false,FILTER_VALIDATE_BOOLEAN),'comision_mayorista'=>NULL,'comision_minorista'=>NULL);
						$this->Generic_model->savebatch('preciosxpresentacion',$preciosData);
						$IDsWheres.=" AND id_presentacion != ".$presentacionId;
					}
				}
			}
			/*Eliminar presentaciones restantes para edicion*/
			if($this->input->post('id_producto') != ''){
				$missespresentaciones=$this->Generic_model->sql_custom('SELECT * FROM presentaciones WHERE id_producto ='.$idproducto.$IDsWheres.' ');
				if(count($missespresentaciones)){
					foreach($missespresentaciones as $misspresentacion){
						$this->Generic_model->delete('presentaciones','id_presentacion',$misspresentacion->id_presentacion);
					}
				}
			}
			/*Registrar transaccion de inventario para existencias*/
			if($this->input->post('existencia_fisica')!=''){
				/*Obtener presentacion primaria*/
				$presentacion_prim=$this->Generic_model->get("presentaciones","id_presentacion",array("id_producto"=>$idproducto,"tipo_presentacion"=>0));
				$presentacion_prim=$presentacion_prim[0]->id_presentacion;
				switch($this->input->post('tipo_transaccion')){
					case "inicial":/*Transaccion de inventario inicial*/
						/*Eliminar transacciones anteriores*/
						if($this->input->post('id_producto')!=''){
							$this->Generic_model->delete("salida_productos","id_producto",$this->input->post('id_producto'));
							$this->Generic_model->delete("entrada_productos","id_producto",$this->input->post('id_producto'));
						}
						/*Registrar inventario inicial*/
						$entradaData=array(
							"fecha_entrada"=>$fecha,
							"id_producto"=>$idproducto,
							"id_presentacion"=>$presentacion_prim,
							"concepto_entrada"=>0,
							"cant_entrada"=>$this->input->post('existencia_fisica'),
							"costo_entrada"=>$this->input->post('transaccion_costo_uni')
						);
						if($this->Generic_model->save("entrada_productos",$entradaData)){
							$this->Generic_model->_update("productos",array("exist_act_producto"=>$this->input->post('existencia_fisica')),array("id_producto"=>$idproducto));
						}
					break;
					case "ajuste":/*Transaccion de ajuste de inventario*/
						$existencia_sistema=$this->input->post('existencia_sistema');
						$existencia_sistema=($existencia_sistema==""?0:$existencia_sistema);
						$diferencia=(float)$this->input->post('existencia_fisica')-(float)$existencia_sistema;
						switch(true){
							case $diferencia<0:/*Salida*/
								$diferencia=abs($diferencia);
								$salidaData=array(
									"fecha_salida"=>$fecha,
									"fecha_reserva"=>$fecha,
									"id_producto"=>$idproducto,
									"id_presentacion"=>$presentacion_prim,
									"concepto_salida"=>9,
									"documento_salida"=>0,
									"num_doc_salida"=>"-",
									"doc_reserva_salida"=>0,
									"num_doc_reserva_salida"=>"-",
									"doc_facturacion"=>0,
									"num_doc_facturacion"=>"-",
									"tipo_salida"=>0,
									"cant_salida"=>$diferencia,
									"costo_salida"=>$this->input->post('transaccion_costo_uni')
								);
								if($this->Generic_model->save("salida_productos",$salidaData)){
									$this->Generic_model->disminuir('productos','id_producto',$idproducto,'exist_act_producto',$diferencia);
								}
							break;
							case $diferencia>0:/*Entrada*/
								/*Registrar entrada a inventario*/
								$entradaData=array(
									"fecha_entrada"=>$fecha,
									"id_producto"=>$idproducto,
									"id_presentacion"=>$presentacion_prim,
									"concepto_entrada"=>9,
									"cant_entrada"=>$diferencia,
									"costo_entrada"=>$this->input->post('transaccion_costo_uni')
								);
								if($this->Generic_model->save("entrada_productos",$entradaData)){
									$this->Generic_model->aumentar('productos','id_producto',$idproducto,'exist_act_producto',$diferencia);
								}
							break;
						}
					break;
				}
			}
			echo $prodDesc.'‡'.$idproducto;
		}
		function eliminar_producto(){	
			if(filter_var($this->permisos['inventario']['inventario-productos-eliminar'],FILTER_VALIDATE_BOOLEAN)){
				if($this->Generic_model->delete('productos','id_producto',$this->input->get('id'))){
					echo 'Borrado';
				}
			}
		}
		function stock_producto(){
			$id=$this->input->get("id");
			$action=$this->input->get("action");
			if($action=="in"){
				echo $this->Generic_model->_update('presentaciones',array("estado_presentacion"=>1),array('id_producto'=>$id,'tipo_presentacion'=>0));
			}else{
				echo $this->Generic_model->_update('presentaciones',array("estado_presentacion"=>0),array('id_producto'=>$id,'tipo_presentacion'=>0));
			}
		}
		function searchProductSKU(){
			$query=$this->Generic_model->get('presentaciones','desc_presentacion',array('sku_presentacion'=>$this->input->get('sku')));
			$response=array(
				"used"=>count($query),
				"prod"=>(isset($query[0]->desc_presentacion)?$query[0]->desc_presentacion:"")
			);
			echo json_encode($response);
		}
		function getSubgrupos(){
			$subgrupos=$this->Generic_model->get('subgrupos','id_subgrupo as id, nombre_subgrupo as nombre',$wheres=array('id_grupo' => $this->input->get('id')));
			echo json_encode($subgrupos);
		}
		function buscarproductos(){
			$UIDataModal["content_view"]= "productos_inventario_buscar_view";
			$UIDataModal["title"]="Buscar producto";
			$UIDataModal["close_button"]=true;
			$UIDataModal["classes"]="modal-lg";
			$UIDataModal["id"]="productos-buscar-modal";
			$UIDataModal["field"]=$this->input->get("field");
			$UIDataModal["enter"]=$this->input->get("enter");
			
			$this->load->view('template_modal',$UIDataModal); 
		}
			function buscar_cargar_productos(){
				$reset=filter_var($this->input->get("reset"),FILTER_VALIDATE_BOOLEAN);
				$getPrecios=filter_var($this->input->get("precios"),FILTER_VALIDATE_BOOLEAN);
				$getExistencia=filter_var($this->input->get("existencia"),FILTER_VALIDATE_BOOLEAN);
				$search=array("desc_presentacion"=>$this->input->get('search'));
				$limits=array(20=>$this->input->get('offset'));
				$productos=$this->Generic_model->get('presentaciones','presentaciones.id_presentacion as id, presentaciones.sku_presentacion as sku, presentaciones.desc_presentacion as desc, presentaciones.unidades_representativas as uequiv, productos.exist_act_producto as existencia',array('estado_presentacion'=>1),array('desc_presentacion'=>'ASC'),$search,array('productos'=>'productos.id_producto = presentaciones.id_producto'),$limits,'','');
				if($getPrecios){
					/*Permisos sobre precios*/
					$preciosPermisos=6;
					$rulesWhere=array();
					if(!filter_var($this->permisos['facturacion']['transacciones-precio1-ver'],FILTER_VALIDATE_BOOLEAN)){
						$rulesWhere['precio_identificador !=']=1;
						$preciosPermisos-=1;
					}
					if(!filter_var($this->permisos['facturacion']['transacciones-precio2-ver'],FILTER_VALIDATE_BOOLEAN)){
						$rulesWhere[' precio_identificador !=']=2;
						$preciosPermisos-=1;
					}
					if(!filter_var($this->permisos['facturacion']['transacciones-precio3-ver'],FILTER_VALIDATE_BOOLEAN)){
						$rulesWhere['  precio_identificador !=']=3;
						$preciosPermisos-=1;
					}
					if(!filter_var($this->permisos['facturacion']['transacciones-precio4-ver'],FILTER_VALIDATE_BOOLEAN)){
						$rulesWhere['   precio_identificador !=']=4;
						$preciosPermisos-=1;
					}
					if(!filter_var($this->permisos['facturacion']['transacciones-precio5-ver'],FILTER_VALIDATE_BOOLEAN)){
						$rulesWhere['    precio_identificador !=']=5;
						$preciosPermisos-=1;
					}
					if(!filter_var($this->permisos['facturacion']['transacciones-precio6-ver'],FILTER_VALIDATE_BOOLEAN)){
						$rulesWhere['     precio_identificador !=']=6;
						$preciosPermisos-=1;
					}
				}
				/*Encabezado tabla*/
				if($reset){
					echo "<thead><tr>";
					echo "<th>Descripci&oacute;n</th>";
					if($getPrecios){
						for($i=0;$i<$preciosPermisos;$i++){
							echo "<th width='9.042%'>Precio ".($i+1)."</th>";
						}
					}
					if($getExistencia){
						echo "<th width='9.4191%'>Existencia</th>";
					}
					echo "</tr></thead>";
					echo "<tbody style='font-size:11px' class='un tbody'>";
				}
				
				/*Cuerpo de la tabla/productos*/
				if($productos>0){
					foreach($productos as $i=>$producto){
						$rulesWhere['id_presentacion']=$producto->id;
						$precios=$this->Generic_model->get('preciosxpresentacion','precio_identificador as identificador, precio_presentacion as precio,precio_porcentaje as porcentaje',$rulesWhere,array('precio_identificador'=>'ASC'));
						echo "<tr id='prod-".$producto->id."' data-sku='".$producto->sku."'>";
						echo "<td>".$producto->desc."</td>";
						if($getPrecios){
							for($i=0;$i<$preciosPermisos;$i++){
								echo ($precios[$i]->precio?"<td>$ ".round($precios[$i]->precio,4)."</td>":"<td>N/A</td>" );
							}
						}
						if($getExistencia){
							echo "<td class='text-right'><strong>".number_format((float)($producto->existencia/$producto->uequiv), 4, '.', '')."</strong></td>";
						}
						echo "</tr>";
					}
				}
				if($reset){
					echo "</tbody>";
				}
			}
			
			function producto_info(){
				$componets=explode(",",$this->input->get('fields'));
				$querySelect='presentaciones.id_producto as producto,presentaciones.id_presentacion as presentacion,presentaciones.unidades_representativas as unidades';
				$getPrecios=$getPresentaciones=false;
				foreach($componets as $componet){
					switch($componet){
						case 'descripcion':$querySelect.=',presentaciones.desc_presentacion as descripcion';break;
						case 'tipo_venta':$querySelect.=',productos.tipo_venta as tipo_venta';break;
						case 'tipo_producto':$querySelect.=',productos.tipo_producto as tipo_producto'; break;
						case 'existencias':$querySelect.=',productos.exist_act_producto as existencias'; break;
						case 'umedida':$querySelect.=',productos.unidad_medida_producto as umedida'; break;
						case 'tipo_presentacion':$querySelect.=',presentaciones.tipo_presentacion as tipo_presentacion';break;
						case 'precios':$getPrecios=true;break;
						case 'presentaciones':$getPresentaciones=true;break;
						case 'costo_ultimo':break;
						case 'costo_promedio':break;
						case 'interno':$querySelect.=',productos.producto_interno as interno';break;
					}
				}
				$query=$this->Generic_model->get('presentaciones',$querySelect,array($this->input->get('conditional')=>$this->input->get('value'),"estado_presentacion"=>1),'','',array('productos'=>'productos.id_producto=presentaciones.id_producto'));
				$presentacion=$query[0]->presentacion;
				$producto=$query[0]->producto;
				if($getPrecios){
					$rulesWhere=array('id_presentacion'=>$presentacion);
					if(!filter_var($this->permisos['facturacion']['transacciones-precio1-ver'],FILTER_VALIDATE_BOOLEAN))
						$rulesWhere['precio_identificador !=']=1;
					if(!filter_var($this->permisos['facturacion']['transacciones-precio2-ver'],FILTER_VALIDATE_BOOLEAN))
						$rulesWhere[' precio_identificador !=']=2;
					if(!filter_var($this->permisos['facturacion']['transacciones-precio3-ver'],FILTER_VALIDATE_BOOLEAN))
						$rulesWhere['  precio_identificador !=']=3;
					if(!filter_var($this->permisos['facturacion']['transacciones-precio4-ver'],FILTER_VALIDATE_BOOLEAN))
						$rulesWhere['   precio_identificador !=']=4;
					if(!filter_var($this->permisos['facturacion']['transacciones-precio5-ver'],FILTER_VALIDATE_BOOLEAN))
						$rulesWhere['    precio_identificador !=']=5;
					if(!filter_var($this->permisos['facturacion']['transacciones-precio6-ver'],FILTER_VALIDATE_BOOLEAN))
						$rulesWhere['     precio_identificador !=']=6;
					$query[0]->precios=$this->Generic_model->get('preciosxpresentacion','precio_identificador as identificador, precio_presentacion as precio,precio_porcentaje as porcentaje',$rulesWhere,array('precio_identificador'=>'ASC'));
				}
				if($getPresentaciones){
					$presentaciones=$this->Generic_model->get('presentaciones','id_presentacion as id,desc_presentacion as desc, unidades_representativas as unidades',array('id_producto'=>$producto));
					foreach($presentaciones as $index=>$_presentacion){
						$presentaciones[$index]->precios=$this->Generic_model->get('preciosxpresentacion','precio_identificador as identificador, precio_presentacion as precio,precio_porcentaje as porcentaje',array('id_presentacion'=>$_presentacion->id),array('precio_identificador'=>'ASC'));
					}
					$query[0]->presentaciones=$presentaciones;
				}
				echo json_encode($query);
			}
			function setprecios(){
				$UIDataModal["content_view"]= "productos_inventario_setprecios_view";
				$UIDataModal["title"]="Establecer precios";
				$UIDataModal["close_button"]=true;
				$UIDataModal["classes"]="modal-lg";
				$UIDataModal["id"]="productos-precios-modal";
				/*Determinar costo presentacion primaria*/
				$presentacion=$this->Generic_model->get('presentaciones','id_presentacion,tipo_presentacion,unidades_representativas',array('id_presentacion'=>$this->input->get('presentacion')));
				if($presentacion[0]->tipo_presentacion==0){
					$costopp=$this->input->get('costo');
				}else{
					$costopp=$this->input->get('costo')/$presentacion[0]->unidades_representativas;
				}
				$presentaciones=$this->Generic_model->get('presentaciones','id_presentacion as id,desc_presentacion as desc,unidades_representativas as unidades',array('id_producto'=>$this->input->get('producto'),'id_presentacion !='=>$this->input->get('presentacion') ));
				if(count($presentaciones)>0){
					foreach($presentaciones as $index=>$_presentacion){
						$presentaciones[$index]->precios=$this->Generic_model->get('preciosxpresentacion','precio_identificador as identificador, precio_presentacion as precio,precio_porcentaje as porcentaje',array('id_presentacion'=>$_presentacion->id),array('precio_identificador'=>'ASC'));
					}
				}
				/*Edicion de preicios pre establecidos*/
				if($this->input->get("precios")=="none"){
					$setprecios=null;
				}else{
					foreach(json_decode($this->input->get("precios")) as $_setpecio){
						$setprecios[$_setpecio->pre]=explode('|',$_setpecio->precios);
					}
				}
				$UIDataModal["preciosWrapper"]=$this->input->get('field');
				$UIDataModal["sender"]=$this->input->get('sender');
				$UIDataModal["precios"]=$this->Generic_model->get('preciosxpresentacion','precio_identificador as identificador, precio_presentacion as precio,precio_porcentaje as porcentaje',array('id_presentacion'=>$this->input->get('presentacion')),array('precio_identificador'=>'ASC'));
				$UIDataModal["setprecios"]=$setprecios;
				$UIDataModal["costo"]=$this->input->get('costo');
				$UIDataModal["costopp"]=$costopp;
				$UIDataModal["usepresentacion"]=$presentacion[0];
				$UIDataModal["presentaciones"]=$presentaciones;
				$this->load->view('template_modal',$UIDataModal);
			}
	/*------------------------- ENTRADAS ----------------------*/
	function entradas(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']="Entradas";
		if(!filter_var($this->permisos['entradas']['entradas-ver'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
		}else{
			$UIData['main_view']="productos_entradas_view";
			$UIData['jsfiles']=array("miracle.transacciones.tools","miracle.entradas","miracle.productos_inventario_buscar.min");
			$UIData['plugins']=array(
				array(
					"nombre"=>"datatables",
					"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
					"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
				),
				array(
					"nombre"=>"chosen",
					"css"=> array('chosen'),
					"js"=> array('chosen.jquery')
				),
				array(
					"nombre"=>"iCheck",
					"css"=>array('custom'),
					"js"=>array('icheck.min')
				),
				array(
					"nombre"=>"datapicker",
					"css"=>array('datepicker3'),
					"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
				),
				array(
					"nombre"=>"daterangepicker",
					"js"=> array('moment.min','daterangepicker'),
					"css"=> array('daterangepicker-bs3')
				)
			);
		}
		$this->load->view('template', $UIData);
		
	}
		function entradas_agrupadas(){
			$data["otras"]=$this->Generic_model->get("entrada_productos","*",array("concepto_entrada"=>0),array("id_entrada"=>"DESC"),"","","","fecha_entrada");
			/* $data["compras"]=$this->Generic_model->get("entrada_productos","*",array("concepto_entrada"=>1),array("id_entrada"=>"DESC"),"",array("compras"=>"compras.id_compra=entrada_productos.id_compra","proveedores"=>"proveedores.id_proveedor=compras.id_proveedor,left outer","usuarios"=>"usuarios.id_usuario=compras.id_usuario,left outer"),"","fecha_entrada");
			$data["devoluciones"]=$this->Generic_model->get("entrada_productos","vendedor.nombre_usuario as vendedor,usuarios.nombre_usuario,fecha_entrada,doc_devolucion,devoluciones.id_devolucion,num_doc_devolucion,grabado_devolucion,exento_devolucion,nosujeto_devolucion,iva_devolucion,id_entrada",array("concepto_entrada"=>2),array("id_entrada"=>"DESC"),"",array("devoluciones"=>"devoluciones.id_devolucion=entrada_productos.id_devolucion","usuarios"=>"usuarios.id_usuario=devoluciones.id_usuario","ventas"=>"ventas.id_venta=devoluciones.id_venta","usuarios as vendedor"=>"vendedor.id_usuario=ventas.id_vendedor"),"","fecha_entrada");
			 */$UIData['cajeros'] = $this->Generic_model->get("usuarios","*",array("id_usuario >" => 0));
			$this->load->view("productos_entradas_agrupadas_tab_view",$UIData);
		}
			/*Datatables nuevos*/
			function cargar_compras(){
				$columns=$this->input->get("columns");
				$search_select=$this->input->get("search_select");
				$search_select_custom=$this->input->get("search_select_custom");
				$search_text=$this->input->get("search_text");
				$likes="";
				$order="";
				$wheres=array(
					"concepto_entrada"=>1
				);
				$joins=array("compras"=>"compras.id_compra=entrada_productos.id_compra","proveedores"=>"proveedores.id_proveedor=compras.id_proveedor,left outer","usuarios"=>"usuarios.id_usuario=compras.id_usuario,left outer");
				if(count($columns)>0){
					$order_data=$this->input->get("order");
					$order_column=$columns[$order_data[0]["column"]]["name"];
					switch($order_column){
						case "referencia":$order=array("id_entrada"=>$order_data[0]["dir"]);break;
						case "fecha":$order=array("fecha_entrada"=>$order_data[0]["dir"]);break;
						case "proveedor":$order=array("nombre_proveedor"=>$order_data[0]["dir"]);break;
						case "usuario":$order=array("nombre_usuario"=>$order_data[0]["dir"]);break;
						case "documento":$order=array("documento_compra"=>$order_data[0]["dir"]);break;
						case "numero":$order=array("num_doc_compra"=>$order_data[0]["dir"]);break;
						case "total":$order=array("subtotal_compra"=>$order_data[0]["dir"]);break;
					}
					switch($search_select){
						case "4":$likes=array("compras.id_compra"=>$search_text);break;
						case "0":$likes=array("fecha_entrada"=>$search_text);break;
						case "1":$likes=array("nombre_proveedor"=>$search_text);break;
						case "2":$wheres=array("concepto_entrada"=>1,"compras.id_usuario"=>$search_select_custom);break;
						case "3":$likes=array("num_doc_compra"=>$search_text);$wheres=array("concepto_entrada"=>1,"compras.documento_compra"=>$search_select_custom);break;
						default:$likes="";break;
					}
				}
				$all_entradas=count($this->Generic_model->get("entrada_productos","*",$wheres,"",$likes,$joins));
				$entradas=$this->Generic_model->get("entrada_productos","id_entrada as id,compras.id_compra as referencia,fecha_entrada as fecha,nombre_proveedor as proveedor,nombre_usuario as usuario,documento_compra as documento,num_doc_compra as numero,(subtotal_compra+iva_compra-retencion_compra+percepcion_compra+total_nosujeto_compra+total_exento_compra) as total",$wheres,$order,$likes,$joins,array($this->input->get("length")=>$this->input->get("start")),"fecha_entrada");
				$data=array();
				$documentos=$this->config->item("documentos_compra");
				if(count($entradas)>0){
					foreach($entradas as $entrada){
						$data[]=array(
							$entrada->id,
							"C-".$entrada->referencia,
							$entrada->fecha,
							$entrada->proveedor,
							$entrada->usuario,
							$documentos[$entrada->documento]["shortName"],
							$entrada->numero,
							$entrada->total,
						);
					}
				}
				$data=array(
					"draw"=>$this->input->get("draw"),
					"recordsTotal"=>$all_entradas,
					"recordsFiltered"=>$all_entradas,
					"data"=>$data
				);
				echo json_encode($data);
			}
			
			function cargar_devoluciones(){
				$columns=$this->input->get("columns");
				/*Search*/
				$search_data=$this->input->get("search");
				$where=array();
				$like=array();
				if(isset($search_data["doc"]) && $search_data["doc"]!=""){
					$where["doc_devolucion"]=$search_data["doc"];
				}
				if(isset($search_data["by"]) && isset($search_data["value"]) && $search_data["value"]!=""){
					switch($search_data["by"]){
						case "referencia":
							$refsearch=explode("-",$search_data["value"]);
							$ref=(isset($refsearch[1])?$refsearch[1]:$search_data["value"]);
							$like["id_devolucion"]=$ref;
						break;
						case "fecha":
							$where["DATE(fecha_devolucion)"]=date("Y-m-d",strtotime($search_data["value"]));
						break;
						case "cajero":
							$where["devoluciones.id_usuario"]=$search_data["value"];
						break;
						case "documento":
							$like["num_doc_devolucion"]=$search_data["value"];
						break;
					}
				}
				/*Order*/
				$order_data=$this->input->get("order");
				$order=array($columns[$order_data[0]["column"]]["name"]=>$order_data[0]["dir"]);
				/*Query*/
				$all_devoluciones=$this->Generic_model->get("devoluciones","id_devolucion",$where,'',$like);
				$all_devoluciones=count($all_devoluciones);
				$devoluciones=$this->Generic_model->get("devoluciones","id_devolucion as referencia,fecha_devolucion as fecha,usuarios.nombre_usuario as cajero,CASE doc_devolucion WHEN 0 THEN 'Ninguno' WHEN 1 THEN 'Factura' WHEN 2 THEN 'CCF' WHEN 3 THEN 'Ticket' WHEN 4 THEN  'N. Remision' WHEN 5 THEN 'N. Envio' ELSE 'Desconocido' END as documento, num_doc_devolucion as numero, (grabado_devolucion+iva_devolucion-retencion_devolucion+percepcion_devolucion+nosujeto_devolucion+exento_devolucion) as total",$where,$order,$like,array("usuarios"=>"usuarios.id_usuario=devoluciones.id_usuario,LEFT"),array($this->input->get("length")=>$this->input->get("start")));
				$devoluciones_data=array();
				if(count($devoluciones)>0){
					foreach($devoluciones as $devolucion){
						$devoluciones_data[]=array("D-".$devolucion->referencia,date("d-m-Y H:i:s", strtotime($devolucion->fecha)),$devolucion->cajero,$devolucion->documento,$devolucion->numero,$devolucion->total,'<button class=\'btn btn-xs btn-primary devoluciones-table-view-btn\' data-id=\''.$devolucion->referencia.'\'>Ver</button>');
					}
				}
				$data=array(
					"draw"=>$this->input->get("draw"),
					"recordsTotal"=>$all_devoluciones,
					"recordsFiltered"=>$all_devoluciones,
					"data"=>$devoluciones_data
				);
				echo json_encode($data);
			}
			
			function cargar_otras(){
				$columns=$this->input->get("columns");
				$search_select=$this->input->get("search_select");
				$search_select_custom=$this->input->get("search_select_custom");
				$search_text=$this->input->get("search_text");
				$likes="";
				$order="";
				$wheres=array(
					"concepto_entrada"=>0
				);
				$joins="";
				if(count($columns)>0){
					$order_data=$this->input->get("order");
					$order_column=$columns[$order_data[0]["column"]]["name"];
					switch($order_column){
						case "referencia":$order=array("id_entrada"=>$order_data[0]["dir"]);break;
						case "fecha":$order=array("fecha_entrada"=>$order_data[0]["dir"]);break;
						case "concepto":$order=array("concepto_entrada"=>$order_data[0]["dir"]);break;
					}
					switch($search_select){
						case "0":$likes=array("fecha_entrada"=>$search_text);break;
						default:$likes="";break;
					}
				}
				$all_entradas=count($this->Generic_model->get("entrada_productos","*",$wheres,"",$likes,$joins));
				$entradas=$this->Generic_model->get("entrada_productos","id_entrada as id,fecha_entrada as fecha,concepto_entrada as concepto",$wheres,$order,$likes,$joins,array($this->input->get("length")=>$this->input->get("start")),"fecha_entrada");
				$data=array();
				if(count($entradas)>0){
					foreach($entradas as $entrada){
						$data[]=array(
							$entrada->id,
							$entrada->fecha,
							$entrada->concepto,
						);
					}
				}
				$data=array(
					"draw"=>$this->input->get("draw"),
					"recordsTotal"=>$all_entradas,
					"recordsFiltered"=>$all_entradas,
					"data"=>$data
				);
				echo json_encode($data);
			}
		function entradas_individuales(){
			$this->load->view("productos_entradas_individuales_view");
		}
		function entradadetalles(){
			$transInfo=$this->Generic_model->get('entrada_productos','fecha_entrada as fecha,concepto_entrada as concepto,id_compra as compra,id_devolucion as devolucion',array('id_entrada'=>$this->input->get('transaccion')));
			$transInfo=$transInfo[0];
			$UIDataModal['entrada']=true;
			$UIDataModal['productos']=$this->Generic_model->get('entrada_productos','presentaciones.sku_presentacion as sku,presentaciones.desc_presentacion as desc,productos.tipo_producto as tipo,entrada_productos.cant_entrada as cant,entrada_productos.costo_entrada as costo',array('fecha_entrada'=>$transInfo->fecha,'concepto_entrada'=>$transInfo->concepto),'','',array('presentaciones'=>'presentaciones.id_presentacion=entrada_productos.id_presentacion','productos'=>'productos.id_producto=entrada_productos.id_producto'));
			if($this->input->get("source")){
				switch($this->input->get("source")){
					case "devolucion":
						$transInfo->concepto=2;
						$transInfo->devolucion=$this->input->get('transaccion');
						$UIDataModal['productos']=$this->Generic_model->get('entrada_productos','presentaciones.sku_presentacion as sku,presentaciones.desc_presentacion as desc,productos.tipo_producto as tipo,entrada_productos.cant_entrada as cant,entrada_productos.costo_entrada as costo',array('id_compra'=>$this->input->get('transaccion'),'concepto_entrada'=>$transInfo->concepto),'','',array('presentaciones'=>'presentaciones.id_presentacion=entrada_productos.id_presentacion','productos'=>'productos.id_producto=entrada_productos.id_producto'));
						break;
					case "compra":break;
				}
			}
			/* $UIDataModal['productos']=$this->Generic_model->get('entrada_productos','productos.sku_producto as sku,productos.desc_producto as desc,productos.tipo_venta as tipo,entrada_productos.cant_entrada as cant,entrada_productos.costo_entrada as costo',array('fecha_entrada'=>$transInfo->fecha,'concepto_entrada'=>$transInfo->concepto),'','',array('productos'=>'productos.id_producto=entrada_productos.id_producto')); */
			
			if($transInfo->concepto==0){/*Inventario inicial*/
				$UIDataModal["title"]="Detalles de entrada por inventario inicial";
				$view='productos_entradas_nueva_inventario_inicial_view';
			}elseif($transInfo->concepto==1){/*compra*/
				$UIDataModal["title"]="Detalles de compra";
				$view='productos_entradas_nueva_compra_view';
				$compra=$this->Generic_model->get('compras','proveedores.nombre_proveedor as nproveedor,proveedores.razonsocial_proveedor as rproveedor,proveedores.clasificacion_proveedor as clasificacion,compras.forma_pago_compra as condicion,compras.documento_compra as doc,compras.num_doc_compra as num',array('id_compra'=>$transInfo->compra),'','',array('proveedores'=>'proveedores.id_proveedor=compras.id_proveedor'));
				$gastoscompra=$this->Generic_model->get('gastoxcompras','desc_gasto as desc, importe_gasto as importe',array('id_compra'=>$transInfo->compra));
				$UIDataModal["compra"]=$compra[0];
				$UIDataModal["gastos"]=$gastoscompra;
			}elseif($transInfo->concepto==2){/*devolucion*/
				$UIDataModal["title"]="Detalles de entrada por devoluci&oacute;n";
				$view='transacciones_devolucion_app_view';
				$devolucion=$this->Generic_model->get('devoluciones','devoluciones.fecha_devolucion as fecha,devoluciones.tipo_devolucion as tipo,ventas.documento_venta as docventa,ventas.num_documento_venta as numdocventa',array('id_devolucion'=>$transInfo->devolucion),'','',array('ventas'=>'ventas.id_venta=devoluciones.id_venta,LEFT'));
				$UIDataModal["devolucion"]=$devolucion[0];
			}
			$UIDataModal["content_view"]=$view;
			$UIDataModal["close_button"]=true;
			$UIDataModal["classes"]="modal-lg";
			$UIDataModal["id"]="inventario-nueva-entrada-modal";
			$this->load->view('template_modal',$UIDataModal); 
		}
		function cargar_entradas_individuales(){
			$this->load->library("ssp");
			
			$table = 'entrada_productos';
			$primaryKey = 'id_entrada';
			
			$columns = array(
				array( 'db' => '`ep`.`fecha_entrada`', 'dt' => 0, 'field' => 'fecha_entrada', 'formatter' => function( $d, $row ) {
					$dateConvert = explode('-',$d);
					$timeConvert = explode(' ',$dateConvert[2]);
					return $timeConvert[0].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0].' a las '.$timeConvert[1];
				}),
				array(
					'db' => '`ep`.`concepto_entrada`',
					'dt' => 1,
					'field' => 'concepto_entrada',
					'formatter' => function( $d, $row ) {
						switch($d):
							case '0':
									return 'Inventario Inicial';
								break;
							case '1':
									return 'Compra';
								break;
							case '2':
									return 'Devolucion';
								break;
						endswitch;
					}
				),
				array( 'db' => '`pr`.`sku_presentacion`', 'dt' => 2, 'field' => 'sku_presentacion' ),
				array( 'db' => '`pr`.`desc_presentacion`', 'dt' => 3, 'field' => 'desc_presentacion' ),
				array(
					'db' => '`ep`.`concepto_entrada`',
					'dt' => 4,
					'field' => 'concepto_entrada',
					'formatter' => function( $d, $row ) {
						switch($d):
							case '0':
									return 'Registro de Inventario Inicial';
								break;
							case '1':
									switch($row[6]):
										case '0':
												return 'Compra segun CCF N°'.$row[7];
											break;
										case '1':
												return 'Compra segun Factura N°'.$row[7];
											break;
										case '2':
												return 'Compra segun Nota de Envio N°'.$row[7];
											break;
									endswitch;
								break;
							case '2':
									return 'Devoluci&oacute;n de mercaderia';
								break;
						endswitch;
					}
				),
				array( 'db' => '`ep`.`costo_entrada`', 'dt' => 5, 'field' => 'costo_entrada' ),
				array( 'db' => '`ep`.`cant_entrada`', 'dt' => 6, 'field' => 'cant_entrada' ),
				array( 'db' => '`co`.`documento_compra`', 'dt' => 7, 'field' => 'documento_compra' ),
				array( 'db' => '`co`.`num_doc_compra`', 'dt' => 8, 'field' => 'num_doc_compra' ),
			);
			$host =  explode(':',$this->db->hostname);
			$sql_details = array(
				'user' => $this->db->username,
				'pass' => $this->db->password,
				'db'   => $this->db->database,
				'host' => $host[0]
			);
			
			$joinQuery = "FROM `entrada_productos` AS `ep` LEFT OUTER JOIN `compras` AS `co` ON (`co`.`id_compra` = `ep`.`id_compra`) LEFT OUTER JOIN `presentaciones` AS `pr` ON (`pr`.`id_presentacion` = `ep`.`id_presentacion`)";
			$extraWhere = "";
			 
			echo json_encode(
				$this->ssp->simple( $this->input->post(), $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere)
			);
		}
		/*Nueva entrada*/
		function entradas_nueva(){
			$UIDataModal["content_view"]= "productos_entradas_nueva_view";
			$UIDataModal["title"]="Nueva entrada";
			$UIDataModal["close_button"]=true;
			$UIDataModal["classes"]="modal-lg";
			$UIDataModal["id"]="inventario-nueva-entrada-modal";
			$UIDataModal["load"]=$this->input->get('load');
			
			$this->load->view('template_modal',$UIDataModal); 
		}
		/*---------- Cargar formulario para transacciones ----------*/
			function entradas_nueva_cargar_form(){
				$data["proveedores"]=$this->Generic_model->get('proveedores','id_proveedor, nombre_proveedor, razonsocial_proveedor,clasificacion_proveedor','',array('nombre_proveedor'=>'ASC'));
				switch($this->input->get("type")){
					 case "0":
						if(!filter_var($this->permisos['entradas']['entradas-registrar-inventario'],FILTER_VALIDATE_BOOLEAN)){
							$this->load->view("error_noacceso_view");
						}else{
							$data=array();
							$view="productos_entradas_nueva_inventario_inicial_view";		
							$this->load->view($view,$data); 
						}
					break;
					case "1":
						if(!filter_var($this->permisos['entradas']['entradas-registrar-compras'],FILTER_VALIDATE_BOOLEAN)){
							$this->load->view("error_noacceso_view");
						}else{
							$view="productos_entradas_nueva_compra_view";
							$this->load->view($view,$data); 
						}
					break;
					 /*default:$view ="restaurante_inventario_transacciones_nueva_desconocida_view";break; */
				}
			}
			function guardar_entradas(){
				$fecha=gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
				$productos=json_decode($this->input->post('productos'));
				$productoslist=array();
				foreach($productos as $producto){
					$productoslist[] = array(
						'id_producto'=>$producto->id_producto,
						'id_presentacion'=>$producto->id_presentacion,
						'cant_entrada'=>$producto->cant_producto,
						'costo_entrada'=>$producto->costo_producto,
						'concepto_entrada'=>0,
						'fecha_entrada'=>$fecha
					);
					$cant=$producto->cant_producto*$producto->uequiv;
					$this->Generic_model->aumentar('productos','id_producto',$producto->id_producto,'exist_act_producto',$cant);
					$preciosPresentaciones=json_decode($producto->precios);
					
					/*Actualizar precios*/
					foreach($preciosPresentaciones as $preciosPresentacion){
						$_preciosxpresentacion=explode('|',$preciosPresentacion->precios);	
					/* 	echo 'llego al foreach'; */
						echo $this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[0]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>1));
						echo $this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[1]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>2));
						echo $this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[2]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>3));
						echo $this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[3]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>4));
						echo $this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[4]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>5));
					}
				}
				if(count($productoslist) > 0):
					$this->Generic_model->savebatch('entrada_productos',$productoslist);
				endif;
			}
			/*Compra*/
			function guardarcompra(){
				$fecha = gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
				$productos=json_decode($this->input->post('productos'));
				$atotales=json_decode($this->input->post('totales'));
				$totales=array();
				foreach($atotales as $total){
					foreach($total as $key => $value){
						$totales[$key]=$value;
					}
				}
				/*Registrar compra*/
				$compraData=array(
					'fecha_compra'=>$fecha,
					'id_usuario'=>null,
					'id_proveedor'=>$this->input->post('proveedor'),
					'forma_pago_compra'=>$this->input->post('condicion'),
					'documento_compra'=>$this->input->post('documento'),
					'num_doc_compra'=>$this->input->post('numero'),
					'subtotal_compra'=>$totales['totalGrabadas'],
					'iva_compra'=>$totales['totalIVA'],
					'percepcion_compra'=>(isset($totales['totalIVApercibido'])?$totales['totalIVApercibido']:0.00),
					'total_nosujeto_compra'=>$totales['totalNS'],
					'total_exento_compra'=>$totales['totalExento']
				);	
				/**/
				$compra=$this->Generic_model->save('compras',$compraData,true);
				/*Registrar costos*/
				$gastosCompra=array();
				$countItem=0;
				foreach($productos as $cproducto){
					$countItem+=$cproducto->cant;
				}
				if($this->input->post('gasto')!='none'){
					$costos=json_decode($this->input->post('gasto'));
					foreach($costos as $costo){
						$gastosCompra[]=array(
							'id_compra'=>$compra,
							'desc_gasto'=>$costo->gasto,
							'importe_gasto'=>$costo->importe
						);
					}
					
					$this->Generic_model->savebatch('gastoxcompras',$gastosCompra);
					$costoAdiUni=$this->input->post('totalgasto')/$countItem;
				}else{
					$costoAdiUni=0;
				}
				/*registrar entrada*//*Preparar array*/
				/* $impuestosUni=($compraData['iva_compra']+$compraData['percepcion_compra'])/$countItem; */
				
				$productoslist = array();
				$productosPreciosList=array();
				foreach($productos as $producto){
					/*Porcentaje de precios para todas las presentaciones*/
					/*Determinar costo presentacion primaria*/
					$presentacionxproducto=$this->Generic_model->get('presentaciones','tipo_presentacion,unidades_representativas',array('id_presentacion'=>$producto->id_presentacion));
					
					$IVAunitario=((((($producto->costo*$producto->cant)*100)/$compraData['subtotal_compra'])/100)*$compraData['iva_compra'])/$producto->cant;
					$IVARetunitario=((((($producto->costo*$producto->cant)*100)/$compraData['subtotal_compra'])/100)*$compraData['percepcion_compra'])/$producto->cant;
					
					if($presentacionxproducto[0]->tipo_presentacion==0){
						$costopp= $producto->costo+$IVARetunitario+$costoAdiUni;/* $producto->costo+$IVAunitario+$IVARetunitario+$costoAdiUni; */
					}else{
						/* $costopp=($producto->costo+$IVAunitario+$IVARetunitario+$costoAdiUni)/$presentacionxproducto[0]->unidades_representativas; */
						$costopp=($producto->costo+$IVARetunitario+$costoAdiUni)/$presentacionxproducto[0]->unidades_representativas;
					}
					/*array para nuevos precios de venta para todas presentaciones*/
					$productoPreciosPresentacion=array();
					$presentacionesAll=$this->Generic_model->get('presentaciones','id_presentacion,unidades_representativas',array('id_producto'=>$producto->id));
					foreach($presentacionesAll as $_pres){
						$productoPreciosPresentacion[]=array(
							'presentacion'=>$_pres->id_presentacion,
							'costototalunitario'=>$costopp,
							'uequiv'=>$_pres->unidades_representativas,
							'precios' => $this->Generic_model->get('preciosxpresentacion','precio_porcentaje,precio_presentacion',array('id_presentacion'=>$_pres->id_presentacion),array("precio_identificador"=>"ASC"))
						);
					}
					$productosPreciosList[]=array(
						'id_producto'=>$producto->id,
						'id_presentacion'=>$producto->id_presentacion,
						'descripcion'=>$producto->desc,
						'costototal'=>$producto->costo+$IVARetunitario+$costoAdiUni,
						'precios'=>$this->Generic_model->get('preciosxpresentacion','*',array('id_presentacion'=>$producto->id_presentacion),array("precio_identificador"=>"ASC")),
						'precios_presentaciones'=>$productoPreciosPresentacion
					);

					$productoslist[] = array(
						'fecha_entrada'=>$fecha,
						'id_producto'=>$producto->id,
						'id_presentacion'=>$producto->id_presentacion,
						'concepto_entrada'=>1,
						'id_compra'=>$compra,
						'cant_entrada'=>$producto->cant,
						'costo_entrada'=>$producto->costo,
						'costo_a_entrada'=>$costoAdiUni
					);
					/*Actualizar inventario*/
					$cant=$producto->cant*$producto->uequiv;
					$this->Generic_model->aumentar('productos','id_producto',$producto->id,'exist_act_producto',$cant);
				}
				$this->Generic_model->savebatch('entrada_productos',$productoslist);
				/*Credito*/
				if($this->input->post('condicion')=='1'){
					$doc = ($this->input->post('documento')=='0' ? 'CCF' : 'Factura');
					$credito=$this->input->post('credito');
					if($credito=='CREATE'){
						$deudaData=array(
							'id_proveedor'=>$this->input->post('proveedor'),
							'monto_deuda'=>$totales['totalTotal'],
							'saldo_deuda'=>$totales['totalTotal'],
							'finalizacion_deuda'=>$this->input->post('fechacred'),
							'estado_deuda'=>0
						);
						$credito=$this->Generic_model->save('deudas',$deudaData,true);
						$transData = array(
							'id_deuda' => $credito,
							'fecha_transaccionxd'=>$fecha,
							'ref_transaccionxd'=> 'Compra segun '.$doc.' numero '.$this->input->post('numero'),
							'tipo_transaccionxd'=>0,
							'monto_transaccionxd'=>$totales['totalTotal'],
							'saldo_transaccionxd'=>$totales['totalTotal']
						);
						$this->Generic_model->save('transaccionesxdeuda',$transData);
					}else{
						$deuda=$this->Generic_model->get('deudas','saldo_deuda as saldo,monto_deuda as monto',array('id_deuda'=>$credito));
						$saldo=$deuda[0]->saldo;
						$monto=$deuda[0]->monto;
						
						if(($saldo+$totales['totalTotal']) > $monto){
							$monto=$saldo+$totales['totalTotal'];
						}
						$deudaData=array(
							'monto_deuda'=>$monto,
							'saldo_deuda'=>$saldo+$totales['totalTotal'],
							'estado_deuda'=>0
						);
						$transData = array(
							'id_deuda'=>$credito,
							'fecha_transaccionxd'=>$fecha,
							'ref_transaccionxd'=> 'Compra segun '.$doc.' numero '.$this->input->post('numero'),
							'tipo_transaccionxd'=>0,
							'monto_transaccionxd'=>$totales['totalTotal'],
							'saldo_transaccionxd'=>$saldo+$totales['totalTotal']
						);
						$this->Generic_model->save('transaccionesxdeuda',$transData);
						$this->Generic_model->update('deudas',$deudaData,'id_deuda',$credito);
					}
				}
			
				$UISetPrecioData['productosPreciosList']=$productosPreciosList;
				$UISetPrecioData['id_compra']=$compra;
				$this->load->view('productos_entrada_compra_set_precios',$UISetPrecioData);
			}
			function _guardarcompra(){$this->load->view('productos_entrada_compra_set_precios');}
			function guardarprecios(){
				$precios=json_decode($this->input->get('precios'));
				foreach($precios as $preciosPresentacion){
					$_preciosxpresentacion=explode('|',$preciosPresentacion->precios);	
					$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[0]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>1));
					$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[1]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>2));
					$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[2]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>3));
					$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[3]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>4));
					$this->Generic_model->_update('preciosxpresentacion',array('precio_presentacion'=>$_preciosxpresentacion[4]),array('id_presentacion'=>$preciosPresentacion->pre,'precio_identificador'=>5));
				}
				echo true;
			}
	/*------------------------- SALIDAS ----------------------*/
	function salidas(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']	= "Salidas";
		if(!filter_var($this->permisos['salidas']['salidas-ver'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
		}else{
			
			$UIData['main_view']	= "productos_salidas_view";
			$UIData['jsfiles']=array("miracle.salidas","miracle.transacciones.tools","miracle.ventas","miracle.clientes","productos_salidas_detalles_venta");
			$UIData['plugins']=array(
				array(
					"nombre"=>"datatables",
					"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
					"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
				),
				array(
					"nombre"=>"chosen",
					"css"=> array('chosen'),
					"js"=> array('chosen.jquery')
				),
				array(
					"nombre"=>"iCheck",
					"css"=>array('custom'),
					"js"=>array('icheck.min')
				),
				array(
					"nombre"=>"datapicker",
					"css"=>array('datepicker3'),
					"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
				),
				array(
					"nombre"=>"input-mask",
					"js"=> array('jquery.inputmask')
				),
				array(
					"nombre"=>"daterangepicker",
					"js"=> array('moment.min','daterangepicker'),
					"css"=> array('daterangepicker-bs3')
				),
			);
		}
		$this->load->view('template', $UIData);
		
	}
		/*Salidas agrupadas*/
		function salidas_agrupadas(){
			/* $data["otras"]=$this->Generic_model->get("salida_productos","*",array("concepto_salida !="=>0),array("id_salida"=>"DESC"),"","","","fecha_salida");
			$data["ventas"]=$this->Generic_model->get("salida_productos","vendedor.nombre_usuario as vendedor,usuarios.nombre_usuario,fecha_salida,documento_venta,ventas.id_venta,num_documento_venta,SUM(subtotal_venta+iva_venta+retencion_venta+percepcion_venta+total_nosujeto_venta+total_exento_venta) as total,id_salida",array("concepto_salida"=>0),array("id_salida"=>"DESC"),"",array("ventas"=>"ventas.id_venta=salida_productos.id_venta","usuarios"=>"usuarios.id_usuario=ventas.id_cajero","usuarios as vendedor"=>"vendedor.id_usuario=ventas.id_vendedor"),"","fecha_salida");
			*/
			$UIData['vendedores'] = $this->Generic_model->get("usuarios","*",array("id_usuario >" => 0)); 
			$this->load->view("productos_salidas_agrupadas_tab_view",$UIData);
		}
			/*CARGAR DATATABLES VENTAS*/
			function cargar_ventas(){
				$columns=$this->input->get("columns");
				/*Search*/
				$search_data=$this->input->get("search");
				$where=array();
				$like=array();
				if(isset($search_data["doc"]) && $search_data["doc"]!=""){
					$where["documento_venta"]=$search_data["doc"];
				}
				if(isset($search_data["by"]) && isset($search_data["value"]) && $search_data["value"]!=""){
					switch($search_data["by"]){
						case "referencia":
							$refsearch=explode("-",$search_data["value"]);
							$ref=(isset($refsearch[1])?$refsearch[1]:$search_data["value"]);
							$like["id_venta"]=$ref;
						break;
						case "fecha":
							$where["DATE(fecha_venta)"]=date("Y-m-d",strtotime($search_data["value"]));
						break;
						case "vendedor":
							$where["id_vendedor"]=$search_data["value"];
						break;
						case "cliente":
							$like["nombre_cliente"]=$search_data["value"];
						break;
						case "documento":
							$like["num_documento_venta"]=$search_data["value"];
						break;
					}
				}
				/*Order*/
				$order_data=$this->input->get("order");
				$order=array($columns[$order_data[0]["column"]]["name"]=>$order_data[0]["dir"]);
				/*Query*/
				$all_ventas=$this->Generic_model->get("ventas","id_venta",$where,'',$like);
				$all_ventas=count($all_ventas);
				$ventas=$this->Generic_model->get("ventas","id_venta as referencia,fecha_venta as fecha,vendedores.nombre_usuario as vendedor,nombre_cliente as cliente,CASE documento_venta WHEN 0 THEN 'Ninguno' WHEN 1 THEN 'Factura' WHEN 2 THEN 'CCF' WHEN 3 THEN 'Ticket' WHEN 4 THEN  'N. Remision' WHEN 5 THEN 'N. Envio' WHEN 8 THEN 'Recibo' ELSE 'Desconocido' END as documento, num_documento_venta as numero, (subtotal_venta+iva_venta-retencion_venta+percepcion_venta+total_nosujeto_venta+total_exento_venta) as total, CASE estado_venta WHEN 0 THEN 'Inactiva' WHEN 1 THEN 'Activa' END as estado",$where,$order,$like,array("usuarios as vendedores"=>"vendedores.id_usuario=ventas.id_vendedor,LEFT"),array($this->input->get("length")=>$this->input->get("start")));
				$ventas_data=array();
				if(count($ventas)>0){
					foreach($ventas as $venta){
						$ventas_data[]=array("V-".$venta->referencia,date("d-m-Y H:i:s", strtotime($venta->fecha)),$venta->vendedor,$venta->cliente,$venta->documento,$venta->numero,$venta->total,'<span class=\'label '.($venta->estado=='Activa'?'label-info':'label-warning').'\'>'.$venta->estado.'</span>','<button class=\'btn btn-xs btn-primary ventas-table-view-btn\' data-id=\''.$venta->referencia.'\'>Ver</button>');
					}
				}
				$data=array(
					"draw"=>$this->input->get("draw"),
					"recordsTotal"=>$all_ventas,
					"recordsFiltered"=>$all_ventas,
					"data"=>$ventas_data
				);
				echo json_encode($data);				
			}
			function cargar_salidas(){
				$columns=$this->input->get("columns");
				/*Search*/
				$search_data=$this->input->get("search");
				$where=array(
					"concepto_salida >"=>0
				);
				$like=array();
				/*Order*/
				$order_data=$this->input->get("order");
				$order=array($columns[$order_data[0]["column"]]["name"]=>$order_data[0]["dir"]);
				/*Query*/
				$all_salidas=$this->Generic_model->get("salida_productos","id_salida",$where,'',$like);
				$all_salidas=count($all_salidas);
				$salidas=$this->Generic_model->get("salida_productos","id_salida as id,fecha_salida as fecha,concepto_salida as concepto",$where,$order,$like,'',array($this->input->get("length")=>$this->input->get("start")),"fecha_salida");
				$salidas_data=array();
				if(count($salidas)>0){
					foreach($salidas as $entrada){
						$concepto="Desnocido. Codigo de concepto: ".$entrada->concepto;
						switch($entrada->concepto){
							case 2:$concepto="Daño o vencimiento";break;
							case 3:$concepto="Perdida o extravio";break;
							case 5:$concepto="Consumo interno";break;
							case 4:$concepto="Devolucion a proveedor";break;
							case 7:$concepto="Anulación de compra";break;
							case 9:$concepto="Ajuste de inventario por aplicaci&oacute;n de auditoria";break;
						}
						$salidas_data[]=array($entrada->fecha,$concepto,'<button class=\'btn btn-xs btn-primary salidas-table-view-btn\' data-id=\''.$entrada->id.'\'>Ver</button>');
					}
				}
				$data=array(
					"draw"=>$this->input->get("draw"),
					"recordsTotal"=>$all_salidas,
					"recordsFiltered"=>$all_salidas,
					"data"=>$salidas_data
				);
				echo json_encode($data);
			}
		function salidas_individuales(){
			$this->load->view("productos_salidas_individuales_view");
		}
		
		function salidadetalles(){
			$transInfo=$this->Generic_model->get('salida_productos','fecha_salida as fecha,concepto_salida as concepto,id_venta as venta,id_proveedor as proveedor,id_compra as compra',array('id_salida'=>$this->input->get('transaccion')));
			$transInfo=$transInfo[0];
			$UIDataModal['salida']=true;
			$productos=$this->Generic_model->get('salida_productos','salida_productos.id_producto as id, salida_productos.id_presentacion as idpre, presentaciones.unidades_representativas as uequiv,productos.producto_interno as interno,presentaciones.sku_presentacion as sku,presentaciones.desc_presentacion as desc,productos.tipo_venta as tipo,salida_productos.cant_salida as cant,salida_productos.costo_salida as costo',array('fecha_salida'=>$transInfo->fecha,'concepto_salida'=>$transInfo->concepto),'','',array('presentaciones'=>'presentaciones.id_presentacion=salida_productos.id_presentacion','productos'=>'productos.id_producto=salida_productos.id_producto'));
			
			if($this->input->get("source")){
				switch($this->input->get("source")){
					case "venta":
						$transInfo->concepto=0;
						$transInfo->venta=$this->input->get('transaccion');
						$productos=$this->Generic_model->get('salida_productos','salida_productos.id_producto as id, salida_productos.id_presentacion as idpre, presentaciones.unidades_representativas as uequiv,productos.producto_interno as interno,presentaciones.sku_presentacion as sku,presentaciones.desc_presentacion as desc,productos.tipo_venta as tipo,salida_productos.cant_salida as cant,salida_productos.costo_salida as costo',array('salida_productos.id_venta'=>$transInfo->venta),'','',array('presentaciones'=>'presentaciones.id_presentacion=salida_productos.id_presentacion','productos'=>'productos.id_producto=salida_productos.id_producto'));
			
					break;
				}
			}/* 
			$productos=$this->Generic_model->get('salida_productos','salida_productos.id_producto as id, salida_productos.id_presentacion as idpre, presentaciones.unidades_representativas as uequiv,productos.producto_interno as interno,presentaciones.sku_presentacion as sku,presentaciones.desc_presentacion as desc,productos.tipo_venta as tipo,salida_productos.cant_salida as cant,salida_productos.costo_salida as costo',array('fecha_salida'=>$transInfo->fecha,'concepto_salida'=>$transInfo->concepto),'','',array('presentaciones'=>'presentaciones.id_presentacion=salida_productos.id_presentacion','productos'=>'productos.id_producto=salida_productos.id_producto'));
			 */
			if($transInfo->concepto==2 ){/*Daño o vencimiento*/
				$UIDataModal["title"]="Detalles de salida por da&ntilde;o o vencimiento";
				$view="productos_salidas_nueva_multiple_view";	
			}elseif($transInfo->concepto==3){/*Perdida o extravio*/
				$UIDataModal["title"]="Detalles de salida por p&eacute;rdida o extrav&iacute;o";
				$view="productos_salidas_nueva_multiple_view";	
			}elseif($transInfo->concepto==5){/*Consumo interno*/
				$UIDataModal["title"]="Detalles de salida por consumo interno";
				$view="productos_salidas_nueva_multiple_view";	
			}elseif($transInfo->concepto==4){/*Devolucion a proveedor*/
				$UIDataModal["title"]="Detalles de salida por devoluci&oacute;n a proveedor";
				$view="productos_salidas_nueva_devolucion_proveedor_view";
				$proveedor=$this->Generic_model->get('proveedores','nombre_proveedor as nproveedor,razonsocial_proveedor as rproveedor,clasificacion_proveedor as clasificacion',array('id_proveedor'=>$transInfo->proveedor));
				$UIDataModal['proveedor']=$proveedor[0];
			}elseif($transInfo->concepto==0){/*Venta*/
				$UIDataModal["title"]="Detalles de salida por venta";
				$view="productos_salidas_detalles_venta_view";
				$querySelects="ventas.id_venta,ventas.fecha_venta,ventas.documento_venta,resoluciones_caja.serie_autorizada,resoluciones_caja.id_resolucion,ventas.num_documento_venta,ventas.estado_venta,ventas.tipo_venta,ventas.origen_venta";
				$querySelects.=",cajas.nombre_caja,ventas.id_caja,ventas.id_cajero,cajero.nombre_usuario as cajero,ventas.id_vendedor,vendedor.nombre_usuario as vendedor,ventas.cobro_venta,ventas.forma_pago_venta,ventas.estado_cobro,transaccionesxcredito.id_credito";
				$querySelects.=",ventas.descargo_venta,ventas.nombre_cliente,ventas.id_cliente,ventas.dui_cliente,ventas.nit_cliente,ventas.nrc_cliente,clientes.clasificacion_cliente";
				$querySelects.=",ventas.subtotal_venta,ventas.iva_venta,(subtotal_venta+iva_venta) as subtotalventa,ventas.retencion_venta,ventas.total_nosujeto_venta,ventas.total_exento_venta,(subtotal_venta+iva_venta-retencion_venta+total_nosujeto_venta+total_exento_venta) as total";
				$queryJoins=array("usuarios as cajero"=>"cajero.id_usuario=ventas.id_cajero, LEFT","usuarios as vendedor"=>"vendedor.id_usuario=ventas.id_vendedor, LEFT","cajas"=>"cajas.id_caja=ventas.id_caja,LEFT","resoluciones_caja"=>"resoluciones_caja.id_resolucion=ventas.id_resolucion, LEFT","transaccionesxcredito"=>"transaccionesxcredito.id_venta=ventas.id_venta,LEFT","clientes"=>"clientes.id_cliente=ventas.id_cliente,LEFT");
				$venta=$this->Generic_model->get('ventas',$querySelects,array('ventas.id_venta'=>$transInfo->venta),'','',$queryJoins);
				$venta=$venta[0];
				$totales=array();
				$totales["grabadas"]=array("title"=>"Ventas grabadas","className"=>"totalGrabadas","value"=>$venta->subtotal_venta); 
				if($venta->documento_venta==2){
					$totales["iva"]=array("title"=>"13 % de IVA","className"=>"totalIVA","value"=>$venta->iva_venta);
					$totales["subtotal"]=array("title"=>"Sub-total","className"=>"totalSubtotal","value"=>$venta->subtotalventa);
				}
				if($venta->clasificacion_cliente==3 || $venta->retencion_venta>0){
					$totales["retencion"]=array("title"=>"(-) IVA retenido","className"=>"totalIVAretenido","value"=>$venta->retencion_venta);
				}
				$totales["nosujeto"]=array("title"=>"Ventas No Sujetas","className"=>"totalNS","value"=>$venta->total_nosujeto_venta);
				$totales["excento"]=array("title"=>"Ventas Exentas","className"=>"totalExento","value"=>$venta->total_exento_venta);
				$totales["totalTotal"]=array("title"=>"TOTAL","className"=>"totalTotal","value"=>$venta->total);
				/*Ajuste para clientes exentos*/
				if(isset($venta->clasificacion_cliente) && (int)$venta->clasificacion_cliente==4){
					if(count($productos)>0){
						foreach($productos as $producto){
							if($producto->tipo==0){
								$producto->tipo=3;
							}
						}
					}
				}				
				$venta->doc_code=$venta->documento_venta;
				if(isset($venta->documento_venta)){
					switch($venta->documento_venta){
						case 0:$venta->documento_venta="Ninguno";break;
						case 1:$venta->documento_venta="Factura";break;
						case 2:$venta->documento_venta="CCF";break;
						case 3:$venta->documento_venta="Ticket";break;
						case 4:$venta->documento_venta="Nota de remisión";break;
						case 5:$venta->documento_venta="Nota de envío";break;
					}
				}
				if(isset($venta->estado_venta)){
					switch($venta->estado_venta){
						case 0:$venta->estado_venta="Anulada";break;
						case 1:$venta->estado_venta="Activa";break;
					}
				}
				if(isset($venta->tipo_venta)){
					switch($venta->tipo_venta){
						case 0:$venta->tipo_venta="Facturada";break;
						case 1:$venta->tipo_venta="En transito";break;
					}
				}
				if(isset($venta->origen_venta)){
					switch($venta->origen_venta){
						case 0:$venta->origen_venta="Venta";break;
						case 1:$venta->origen_venta="Pago de crédito";break;
						case 2:$venta->origen_venta="Facturacion crédito";break;
					}
				}
				if(isset($venta->cobro_venta)){
					switch($venta->cobro_venta){
						case 0:$venta->cobro_venta="Contado";break;
						case 1:$venta->cobro_venta="Crédito";break;
						case 2:$venta->cobro_venta="Sin ingreso";break;
						case 3:$venta->cobro_venta="A cobro";break;
					}
				}
				if(isset($venta->forma_pago_venta)){
					switch($venta->forma_pago_venta){
						case 0:$venta->forma_pago_venta="N/A";break;
						case 1:$venta->forma_pago_venta="Efectivo";break;
						case 2:$venta->forma_pago_venta="Cheque";break;
						case 3:$venta->forma_pago_venta="POS";break;
						case 4:$venta->forma_pago_venta="Abono a cuenta";break;
						case 5:$venta->forma_pago_venta="Pago electrónic";break;
					}
				}
				if(isset($venta->estado_cobro)){
					switch($venta->estado_cobro){
						case 0:$venta->estado_cobro="Pendiente";break;
						case 1:$venta->estado_cobro="Parcial";break;
						case 2:$venta->estado_cobro="Total";break;
					}
				}
				if(isset($venta->descargo_venta)){
					switch($venta->descargo_venta){
						case 0:$venta->descargo_venta="Pendiente";break;
						case 1:$venta->descargo_venta="Parcial";break;
						case 2:$venta->descargo_venta="Total";break;
					}
				}
				$venta->totales=$totales;				
				$UIDataModal['venta']=$venta;
			}
			else if($transInfo->concepto==7){
				$UIDataModal["title"]="Detalles de salida por anulaci&oacute;n de compra";
				$compra=$this->Generic_model->get('compras','id_compra as id,fecha_compra as fecha,id_proveedor as proveedor,forma_pago_compra as formapago,(subtotal_compra + iva_compra + percepcion_compra + total_nosujeto_compra + total_exento_compra) as total',array('id_compra'=>$transInfo->compra));
				$compra=$compra[0];
				 if($compra){
					$UIDataModal['compra']=$compra;
				}else{
					$UIDataModal['compra']=null;
				} 
				$view="productos_salidas_nueva_anulacion_compra_compra_view";
			}
			if(isset($view) && $view!=""){
				$UIDataModal["content_view"]=$view;
			}else{
				$UIDataModal["content_view"]="error_nodisponible_view";
			}
			$UIDataModal['productos']=$productos;$UIDataModal["close_button"]=true;
			$UIDataModal["classes"]="modal-lg";
			$UIDataModal["id"]="inventario-nueva-entrada-modal";
			$this->load->view('template_modal',$UIDataModal);
		}
		function cargar_salidas_individuales(){
			$this->load->library("ssp");
			
			$table = 'salida_productos';
			$primaryKey = 'id_salida';
			
			$columns = array(
				array( 'db' => '`sp`.`fecha_salida`', 'dt' => 0, 'field' => 'fecha_salida', 'formatter' => function( $d, $row ) {
					$dateConvert = explode('-',$d);
					$timeConvert = explode(' ',$dateConvert[2]);
					return $timeConvert[0].' de '.$this->TraducirMes($dateConvert[1]).' del '.$dateConvert[0].' a las '.$timeConvert[1];
				}),
				array(
					'db' => '`sp`.`concepto_salida`',
					'dt' => 1,
					'field' => 'concepto_salida',
					'formatter' => function( $d, $row ) {
						switch($d):
							case '0':
									return 'Ventas';
								break;
							case '1':
									return 'Pedido';
								break;
							case '2':
									return 'Dano o vencimiento';
								break;
							case '3':
									return 'Perdida o extravio';
								break;
							case '4':
									return 'Devolucion a Proveedor';
								break;
							case '5':
									return 'Consumo Interno';
								break;
							case '6':
									return 'Facturas a Mano';
								break;
							case '7':
									return 'Compra anulada';
								break;
						endswitch;
					}
				),
				array( 'db' => '`pr`.`sku_presentacion`', 'dt' => 2, 'field' => 'sku_presentacion' ),
				array( 'db' => '`pr`.`desc_presentacion`', 'dt' => 3, 'field' => 'desc_presentacion' ),
				array(
					'db' => '`sp`.`concepto_salida`',
					'dt' => 4,
					'field' => 'concepto_salida',
					'formatter' => function( $d, $row ) {
						switch($d):
							case '0':
									switch($row[6]):
										case '0':
												return 'Venta segun CCF '.$row[7];
											break;
										case '1':
												return 'Venta segun Factura N°'.$row[7];
											break;
										case '2':
												return 'Venta segun Ticket N°'.$row[7];
											break;
										case '3':
												return 'Venta sin documento '.$row[7];
											break;
										case '4':
												return 'Venta segun Nota de Envio '.$row[7];
											break;
										case '5':
												return 'Venta segun Nota de Remision '.$row[7];
											break;
									endswitch;
								break;
							case '1':
									return 'Pedido';
								break;
							case '2':
									return 'Dano o vencimiento';
								break;
							case '3':
									return 'Perdida o extravio';
								break;
							case '4':
									return 'Devolucion a Proveedor';
								break;
							case '5':
									return 'Consumo Interno';
								break;
							case '6':
									return 'Facturas a Mano';
								break;
							case '7':
								switch($row[9]):
									case '0':
											return 'Compra segun CCF N° '.$row[10];
										break;
									case '1':
											return 'Compra segun Factura N° '.$row[10];
										break;
									case '2':
											return 'Compra segun Nota de Envio N° '.$row[10];
										break;
									case '3':
											return 'Compra segun Recibo N° '.$row[10];
										break;
								endswitch;
								break;
						endswitch;
					}
				),
				array( 'db' => '`sp`.`cant_salida`', 'dt' => 5, 'field' => 'cant_salida' ),
				array( 'db' => '`ve`.`documento_venta`', 'dt' => 6, 'field' => 'documento_venta' ),
				array( 'db' => '`ve`.`num_documento_venta`', 'dt' => 7, 'field' => 'num_documento_venta' ),
				array( 'db' => '`pv`.`nombre_proveedor`', 'dt' => 8, 'field' => 'nombre_proveedor' ),
				array( 'db' => '`co`.`documento_compra`', 'dt' => 9, 'field' => 'documento_compra' ),
				array( 'db' => '`co`.`num_doc_compra`', 'dt' => 10, 'field' => 'num_doc_compra' ),
			);
			$host =  explode(':',$this->db->hostname);
			$sql_details = array(
				'user' => $this->db->username,
				'pass' => $this->db->password,
				'db'   => $this->db->database,
				'host' => $host[0]
			);
			
			$joinQuery = "FROM `salida_productos` AS `sp` LEFT OUTER JOIN `ventas` AS `ve` ON (`ve`.`id_venta` = `sp`.`id_venta`) LEFT OUTER JOIN `presentaciones` AS `pr` ON (`pr`.`id_presentacion` = `sp`.`id_presentacion`) LEFT OUTER JOIN `proveedores` AS `pv` ON (`pv`.`id_proveedor` = `sp`.`id_proveedor`) LEFT OUTER JOIN `compras` AS `co` ON (`co`.`id_compra` = `sp`.`id_compra`)";
			$extraWhere = "";
			 
			echo json_encode(
				$this->ssp->simple( $this->input->post(), $sql_details, $table, $primaryKey, $columns, $joinQuery, $extraWhere)
			);
		}
		/*Nueva salida*/
		function salidas_nueva(){
			$UIDataModal["content_view"]= "productos_salidas_nueva_view";
			$UIDataModal["title"]="Nueva salida";
			$UIDataModal["close_button"]=true;
			$UIDataModal["classes"]="modal-lg";
			$UIDataModal["id"]="inventario-nuevo-producto-modal";
			
			$this->load->view('template_modal',$UIDataModal); 
		}
			/*Nueva salida cargar form*/
			function salidas_nueva_cargar_form(){
				$data=array();
				$transaccion=$this->input->get("type");
				if($transaccion=='2'){/*Daño o vencimiento,*/
					if(!filter_var($this->permisos['salidas']['salidas-dano'],FILTER_VALIDATE_BOOLEAN)){
						$view="error_noacceso_view";
					}else{
						$view="productos_salidas_nueva_multiple_view";
					}	
					$this->load->view($view,$data); 
				}elseif($transaccion=='3'){/*Perdida o extravio*/
					if(!filter_var($this->permisos['salidas']['salidas-extravios'],FILTER_VALIDATE_BOOLEAN)){
						$view="error_noacceso_view";
					}else{
						$view="productos_salidas_nueva_multiple_view";	
					}	
					$this->load->view($view,$data); 
				}elseif($transaccion=='5'){/*consumo interno*/
					if(!filter_var($this->permisos['salidas']['salidas-interno'],FILTER_VALIDATE_BOOLEAN)){
						$view="error_noacceso_view";
					}else{
						$view="productos_salidas_nueva_multiple_view";		
					}
					$this->load->view($view,$data); 
				}elseif($transaccion=='4' ){/*Devolucion a proveedor*/
					if(!filter_var($this->permisos['salidas']['salidas-devpro'],FILTER_VALIDATE_BOOLEAN)){
						$this->load->view("error_noacceso_view");
					}else{
						$data["proveedores"]=$this->Generic_model->get('proveedores','id_proveedor, nombre_proveedor, razonsocial_proveedor,clasificacion_proveedor','',array('nombre_proveedor'=>'ASC'));
						$view="productos_salidas_nueva_devolucion_proveedor_view";		
						$this->load->view($view,$data); 
					}
				}elseif($transaccion=='6'){/*Facturas a mano*/
					if(!filter_var($this->permisos['salidas']['salidas-facturas'],FILTER_VALIDATE_BOOLEAN)){
						$view="error_noacceso_view";
						$this->load->view($view,$data); 
					}else{
						echo "<h1 class='text-center'>Aplicaci&oacute;n en desarrollo</h1>";						
					}
					
				}elseif($transaccion=='7'){/*Anulacion de compras*/
					if(!filter_var($this->permisos['salidas']['salidas-anulcompra'],FILTER_VALIDATE_BOOLEAN)){
						$this->load->view("error_noacceso_view");
					}else{
						$data["proveedores"]=$this->Generic_model->get('proveedores','id_proveedor, nombre_proveedor, razonsocial_proveedor,clasificacion_proveedor','',array('nombre_proveedor'=>'ASC'));
						$this->load->view('productos_salidas_nueva_anulacion_compra_view',$data);
					}
				}
			}
			function cargarcompra(){
				$compra=$this->Generic_model->get('compras','id_compra as id,fecha_compra as fecha,id_proveedor as proveedor,forma_pago_compra as formapago,(subtotal_compra + iva_compra + percepcion_compra + total_nosujeto_compra + total_exento_compra) as total',array('id_proveedor'=>$this->input->get('proveedor'),'documento_compra'=>$this->input->get('doc'),'num_doc_compra'=>$this->input->get('numdoc')));
				$compra=$compra[0];
				if($compra){
					$UIData['compra']=$compra;
					$UIData['productos']=$this->Generic_model->get('entrada_productos','entrada_productos.id_producto as id, entrada_productos.id_presentacion as idpre, presentaciones.unidades_representativas as uequiv, presentaciones.sku_presentacion as sku,presentaciones.desc_presentacion as desc,productos.tipo_producto as tipo,entrada_productos.cant_entrada as cant,entrada_productos.costo_entrada as costo',array('id_compra'=>$compra->id),'','',array('presentaciones'=>'presentaciones.id_presentacion=entrada_productos.id_presentacion','productos'=>'productos.id_producto=entrada_productos.id_producto'));
				}else{
					$UIData['compra']=null;
					$UIData['productos']=null;
				}
				$this->load->view('productos_salidas_nueva_anulacion_compra_compra_view',$UIData);			
			}
		function guardarsalida(){
			$proveedor=$this->input->post('proveedor');
			$fecha=gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
			$productos=json_decode($this->input->post('productos'));
			$productoslist=array();
			foreach($productos as $producto){
				$productoslist[] = array(
					'fecha_salida'=>$fecha,
					'id_producto'=>$producto->id,
					'concepto_salida'=>$this->input->post('salida'),
					'ref_transaccion_salida'=>$fecha,
					'id_proveedor'=>$proveedor,
					'cant_salida'=>$producto->cant,
					'costo_salida'=>$producto->costo
				);
				$this->Generic_model->disminuir('productos','id_producto',$producto->id,'exist_act_producto',$producto->cant);
			}
			$this->Generic_model->savebatch('salida_productos',$productoslist);
		}
		function guardaranularcompra(){
			$fecha=gmdate('Y-m-d H:i:s', strtotime('- 6 hours'));
			$compra=$this->input->post('compra');
			$credito=$this->input->post('credito');
			$total=$this->input->post('total');
			$productos=json_decode($this->input->post('productos'));
			$productoslist=array();
			foreach($productos as $producto){
				$productoslist[] = array(
					'fecha_salida'=>$fecha,
					'id_producto'=>$producto->id,
					'id_presentacion'=>$producto->pre,
					'concepto_salida'=>7,
					'id_compra'=>$compra,
					'cant_salida'=>$producto->cant,
					'costo_salida'=>$producto->costo
				);
				/*Actualizar inventario*/
				$cant=$producto->cant*$producto->uequiv;
				$this->Generic_model->disminuir('productos','id_producto',$producto->id,'exist_act_producto',$cant);
			}
			$this->Generic_model->savebatch('salida_productos',$productoslist);
			
			if($credito!='' && $credito!='ninguna'){
				$ccredito=$this->Generic_model->get('deudas','saldo_deuda as saldo',array('id_deuda'=>$credito));
				$saldo=$ccredito[0]->saldo;
				$creditoData=array('saldo_deuda'=>$saldo-$total);
				$transData = array(
					'id_deuda'=>$credito,
					'id_usuario'=>$this->session_['userid'],
					'fecha_transaccionxd'=>$fecha,
					'ref_transaccionxd'=>'Anulaci&oacute;n de compra con abono automatico a deuda',
					'tipo_transaccionxd'=>1,
					'monto_transaccionxd'=>$total,
					'saldo_transaccionxd'=>$saldo-$total
				);
				$this->Generic_model->save('transaccionesxdeuda',$transData);
				$this->Generic_model->update('deudas',$creditoData,'id_deuda',$credito);
			}
			echo true;
		}
	/*------------------------- LINEAS ----------------------*/
	function lineas(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']="Lineas";
		if(!filter_var($this->permisos['lineas']['lineas-crud'],FILTER_VALIDATE_BOOLEAN)){
			$UIData['main_view']="error_noacceso_view";
		}else{
			$UIData['main_view']="productos_lineas_view";
			
			$UIData['jsfiles']=array("miracle.lineas");
			/* $UIdata['jsplugins']		= array('/jsTree/jstree.min','/zebra_dialog/zebra_dialog','/validate/jquery.validate.min','/../pages/lineas');
			$UIdata['cssplugins']		= array('/jsTree/style.min','/zebra_dialog/zebra_dialog'); */
			$UIData['plugins']=array(
				array(
					"nombre"=>"jsTree",
					"css"=> array('style.min'),
					"js"=> array('jsTree.min')
				),
				array(
					"nombre"=>"datapicker",
					"css"=>array('datepicker3'),
					"js"=>array('bootstrap-datepicker','locales/bootstrap-datepicker.es')
				),
				array(
					"nombre"=>"datatables",
					"css"=> array('dataTables.bootstrap','dataTables.responsive','dataTables.tableTools.min'),
					"js"=> array('jquery.dataTables','dataTables.bootstrap.min','dataTables.responsive','dataTables.tableTools.min')
				),
			);
		}
		$this->load->view('template', $UIData);
	}
	function guardar_linea(){
		$data = array('nombre_grupo' => $this->input->post('grupo'));
		if($idgrupo = $this->Generic_model->save('grupos',$data,true)){
			$wheres = array(
				'id_grupo' => $idgrupo
			);
			$subgrupos = json_decode($this->input->post('subgrupos'));
			$subgruposlist = array();
			if($subgrupos != ""){
				foreach($subgrupos as $subgrupo){					
					$subgruposlist[] = array(
						'id_grupo' => $idgrupo,
						'nombre_subgrupo' => $subgrupo->nombre_subgrupo
					);
				}
				if(count($subgruposlist) > 0):
					$this->Generic_model->savebatch('subgrupos',$subgruposlist);
				endif;
			}
		}
	}
	function cargarlineas(){
		$grupos=$this->Generic_model->get('grupos','*');
		$lineas=null;
		 if(count($grupos)>0){
			 foreach($grupos as $grupo){
				 $lineas[]=array(
					 'id_grupo'=>$grupo->id_grupo,
					 'nombre_grupo'=>$grupo->nombre_grupo,
					 'subgrupos'=>(array)$this->Generic_model->get('subgrupos','*',array('id_grupo'=>$grupo->id_grupo))
				 );
			 }
		 }
		echo json_encode($lineas);
	}
		function editarlinea(){			
			if($this->input->get('tabla')=='grupos'){
				$field='id_grupo';
				$data=array('nombre_grupo'=>$this->input->get('value'));
			}else{
				$field='id_subgrupo';
				$data=array('nombre_subgrupo'=>$this->input->get('value'));
			}
			echo $this->Generic_model->update($this->input->get('tabla'),$data,$field,$this->input->get('id'));
		}
		function guardarsubgrupo(){
			echo $this->Generic_model->save('subgrupos',array('id_grupo'=>$this->input->get('grupo'),'nombre_subgrupo'=>$this->input->get('subgrupo')),true);
		}
		function eliminargrupo(){
			echo $this->Generic_model->delete('grupos','id_grupo',$this->input->get('id'));
		}
		function eliminarsubgrupo(){
			echo $this->Generic_model->delete('subgrupos','id_subgrupo',$this->input->get('id'));
		}
	/*Ubicaciones y unidades de medida*/
	function ubicaciones(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']	= "Ubicaciones";
		$UIData['main_view']	= "ubicaciones_view";
		$UIData['jsfiles']=array("miracle.ubicaciones");
		$UIData['plugins']=array(
			array(
				"nombre"=>"jquery_form",
				"js"=> array('jquery.form.min')
			),
		);
		$this->load->view('template', $UIData);
	}
		function cargarubicaciones(){
			$search=array("nombre_ubicacion"=>$this->input->get('search'));
			$limits=array(12=>$this->input->get('offset'));
			echo json_encode($this->Generic_model->get('ubicaciones','id_ubicacion as id, nombre_ubicacion as nombre','',array('nombre_ubicacion'=>'ASC'),$search,'',$limits));
		}
		function cargarubicacioneshtml(){
			$search=array("nombre_ubicacion"=>$this->input->get('search'));
			$limits=array(20=>$this->input->get('offset'));
			$ubicaciones=$this->Generic_model->get('ubicaciones','id_ubicacion as id, nombre_ubicacion as nombre','',array('nombre_ubicacion'=>'ASC'),$search);
			if(count($ubicaciones)>0){
				foreach($ubicaciones as $ubicacion){
					echo "<tr id='ubicacion-".$ubicacion->id."' style='"."height:65px;"."'><td><h4 class='noselecttext'>".$ubicacion->nombre."</h4></td></tr>"; 
				}
			}
		}
		function nueva_ubicacion(){
			$mode=$this->input->get('mode');
			$UIDataModal["content_view"]="ubicaciones_nueva_view";
			$UIDataModal["close_button"] = true;
			$UIDataModal["classes"] = "modal-xs";
			$UIDataModal["id"] = "nueva-ubicacion-modal";
			if($mode=='edit'){
				$UIDataModal["title"]="Editar ubicacion";
				$UIDataModal['ubicacion']=$this->Generic_model->get('ubicaciones','*',array('id_ubicacion'=>$this->input->get('id')));
			}else{
				$UIDataModal["title"]="Nueva ubicacion";
			}
			$this->load->view('template_modal',$UIDataModal);
		}
		function guardarubicacion(){
			$ubicacionData=array(
				'nombre_ubicacion'=>$this->input->post('nombre_ubicacion')
			);
			if($this->input->post('id_ubicacion')){
				echo $this->Generic_model->update('ubicaciones',$ubicacionData,'id_ubicacion',$this->input->post('id_ubicacion'));
			}else{
				echo $this->Generic_model->save('ubicaciones',$ubicacionData);
			}
		}
		function detalles_ubicacion(){
			$ubicacion=$this->Generic_model->get('ubicaciones','*',array('id_ubicacion'=>$this->input->get('id')));
			$UIDataModal['ubicacion']=$ubicacion[0];
			$this->load->view('ubicaciones_detalles_view',$UIDataModal);
		}
		function eliminar_ubicacion(){
			echo $this->Generic_model->delete('ubicaciones','id_ubicacion',$this->input->get('id'));
		}
	function unidades(){
		$UIData['user_info']=$this->usuario;
		$UIData['section_title']	= "Unidades de Medida";
		$UIData['main_view']	= "unidades_view";
		$UIData['jsfiles']=array("miracle.unidades");
		$UIData['plugins']=array(
			array(
				"nombre"=>"jquery_form",
				"js"=> array('jquery.form.min')
			),
		);
		$this->load->view('template', $UIData);
	}
		function cargarunidades(){
			$search=array("nombre_unidad"=>$this->input->get('search'));
			$limits=array(12=>$this->input->get('offset'));
			echo json_encode($this->Generic_model->get('unidades','id_unidad as id, nombre_unidad as nombre','',array('nombre_unidad'=>'ASC'),$search,'',$limits));
		}
		function cargarunidadeshtml(){
			$search=array("nombre_unidad"=>$this->input->get('search'));
			$limits=array(20=>$this->input->get('offset'));
			$unidades=$this->Generic_model->get('unidades','id_unidad as id, nombre_unidad as nombre','',array('nombre_unidad'=>'ASC'),$search);
			if(count($unidades)>0){
				foreach($unidades as $unidad){
					echo "<tr id='unidad-".$unidad->id."' style='"."height:65px;"."'><td><h4 class='noselecttext'>".$unidad->nombre."</h4></td></tr>"; 
				}
			}
		}
		function nueva_unidad(){
			$mode=$this->input->get('mode');
			$UIDataModal["content_view"]="unidades_nueva_view";
			$UIDataModal["close_button"] = true;
			$UIDataModal["classes"] = "modal-xs";
			$UIDataModal["id"] = "nueva-unidad-modal";
			if($mode=='edit'){
				$UIDataModal["title"]="Editar unidad";
				$UIDataModal['unidad']=$this->Generic_model->get('unidades','*',array('id_unidad'=>$this->input->get('id')));
			}else{
				$UIDataModal["title"]="Nueva unidad";
			}
			$this->load->view('template_modal',$UIDataModal);
		}
		function guardarunidad(){
			$unidadData=array(
				'nombre_unidad'=>$this->input->post('nombre_unidad')
			);
			if($this->input->post('id_unidad')){
				echo $this->Generic_model->update('unidades',$unidadData,'id_unidad',$this->input->post('id_unidad'));
			}else{
				echo $this->Generic_model->save('unidades',$unidadData);
			}
		}
		function detalles_unidad(){
			$unidad=$this->Generic_model->get('unidades','*',array('id_unidad'=>$this->input->get('id')));
			$UIDataModal['unidad']=$unidad[0];
			$this->load->view('unidades_detalles_view',$UIDataModal);
		}
		function eliminar_unidad(){
			echo $this->Generic_model->delete('unidades','id_unidad',$this->input->get('id'));
		}
	function timequery(){
	   static $querytime_begin;
	   list($usec, $sec) = explode(' ',microtime());
		   if(!isset($querytime_begin))
		  {   
			 $querytime_begin= ((float)$usec + (float)$sec);
		  }
		  else
		  {
			 $querytime = (((float)$usec + (float)$sec)) - $querytime_begin;
			 return sprintf('%01.5f segundos ', $querytime);
		  }
	}
	function TraducirMes($month){
		switch($month){
			case '01':
					return $mes = 'Enero';
				break;
			case '02':
					return $mes = 'Febrero';
				break;
			case '03':
					return $mes = 'Marzo';
				break;
			case '04':
					return $mes = 'Abril';
				break;
			case '05':
					return $mes = 'Mayo';
				break;
			case '06':
					return $mes = 'Junio';
				break;
			case '07':
					return $mes = 'Julio';
				break;
			case '08':
					return $mes = 'Agosto';
				break;
			case '09':
					return $mes = 'Septiembre';
				break;
			case '10':
					return $mes = 'Octubre';
				break;
			case '11':
					return $mes = 'Noviembre';
				break;
			case '12':
					return $mes = 'Diciembre';
				break;
		}
	}
	function is_logged_in(){
		$session = $this->session->userdata('userInfo');
		$is_logged_in =$session['is_logged_in'];
		
		if(!isset($is_logged_in) || $is_logged_in !== true){
			redirect(base_url("login"));
			die();
		}
	}
}
?>