<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$acum = 0;
	
	/*Init*/
	$printer = printer_open("EPSON LX-300+II ESC/P");

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Devolucion Numero: '.$numero = 1);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 10, 8, PRINTER_FW_BOLD, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($configs['NombreEmpresa'])),28),1,$printer,$acum,10,10);
	
	printer_delete_font($font);
	
	$font = printer_create_font('Arial', 10, 8, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($configs['RazonSocialEmpresa'])),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($configs['DireccionEmpresa'])),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('NRC: '.$configs['NRCEmpresa'])),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('NIT: '.$configs['NITEmpresa'])),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Autorizacion segun Resolucion')),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('No '.$resolucion[0]->num_resolucion)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Del '.$resolucion[0]->tiraje_desde)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Al '.$resolucion[0]->tiraje_hasta)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Ticket '.$numero)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Caja: '.$cajaInfo[0]->nombre_caja)),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('Vendedor: '.$vendedor[0]->nombre_usuario)),28),1,$printer,$acum,10,10);
	
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('*DEVOLUCION*')),28),1,$printer,$acum,10,10);
	
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString(strtoupper(utf8_decode('fecha: ')),2,$printer,$acum,10,10,0);
	$phpPrinter->printString(strtoupper(utf8_decode(date('d-m-Y H:m:s'))),2,$printer,$acum,10,0,80);
	
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString(strtoupper(utf8_decode('Cant')),2,$printer,$acum,10,10,0);
	$phpPrinter->printString(strtoupper(utf8_decode('Desc')),2,$printer,$acum,10,0,70);
	$phpPrinter->printString(strtoupper(utf8_decode('P/U')),2,$printer,$acum,10,0,200);
	$phpPrinter->printString(strtoupper(utf8_decode('Total')),2,$printer,$acum,10,0,270);
	
	$phpPrinter->tabPrinter($acum,5);
	
	foreach($productos as $producto){
		$phpPrinter->printString($producto->cant,2,$printer,$acum,10,10,0);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc))),12),2,$printer,$acum,10,0,50);
		$phpPrinter->printString("(".$producto->costo.")",2,$printer,$acum,10,0,200);
		$phpPrinter->printString("(".($producto->cant * $producto->costo).")",2,$printer,$acum,10,0,270);
		$phpPrinter->tabPrinter($acum,3);
	}
	
	$phpPrinter->tabPrinter($acum,20);
	
	$phpPrinter->printString(strtoupper(utf8_decode('TOTAL GRAVADO')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString("(".$totales['totalGrabadas'].")",2,$printer,$acum,10,0,270);
	$phpPrinter->printString(strtoupper(utf8_decode('TOTAL EXENTO')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString("(".$totales['totalExento'].")",2,$printer,$acum,10,0,270);
	$phpPrinter->printString(strtoupper(utf8_decode('TOTAL NO SUJETO')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString("(".$totales['totalNS'].")",2,$printer,$acum,10,0,270);
	$phpPrinter->printString(strtoupper(utf8_decode('TOTAL A DEVOLVER')),2,$printer,$acum,10,10,50);
	$phpPrinter->printString("(".$totales['totalTotal'].")",2,$printer,$acum,10,0,270);
	
	$phpPrinter->tabPrinter($acum,10);
	
	/*Cliente*/
	$nombre_cliente = "";
	$direccion_cliente = "";
	$nit_cliente = "";
	$nrc_cliente = "";
	$dui_cliente = "";
	if(is_array($cliente)){
		$nombre_cliente = $cliente[0]->nombre_cliente;
		$direccion_cliente = $cliente[0]->direccion_cliente;
		$nrc_cliente = $cliente[0]->ncr_cliente;
		$dui_cliente = $cliente[0]->dui_cliente;
		$nit_cliente = $cliente[0]->nit_cliente;
	}else{
		$nombre_cliente = $cliente;
		$nrc_cliente = $nrc;
		$dui_cliente = $dui;
		$nit_cliente = $nit;
	}
	
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('F:__________________________')),28),1,$printer,$acum,10,10);
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($nombre_cliente)),28),1,$printer,$acum,10,10);
	if($dui_cliente!=""){
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('DUI: '.$dui_cliente)),28),1,$printer,$acum,10,10);
	}
	if($nit_cliente!=""){
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('NIT: '.$nit_cliente)),28),1,$printer,$acum,10,10);
	}
	if($nrc_cliente!=""){
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode('NIT: '.$nrc_cliente)),28),1,$printer,$acum,10,10);
	}
	
	$phpPrinter->tabPrinter($acum,10);
	
	$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode($configs['MensajeTicket'])),28),1,$printer,$acum,10,10);
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>