var Ubicaciones=function(){
	this.baseUrl=null;
	this.scroll=true;
	this.test=function(){
		console.log('La clase Ubicaciones ha sido instanciado correctamente');
	}
	this.setUrl=function(url){
		this.baseUrl=url;
	}
	this.guardar=function(e,action){
		e.preventDefault();
		var $form=$(e.target);
		$form.find(":submit").prop('disabled', true);
		var _this=this;
		var clienteID=null;
		$form.ajaxSubmit({
			success:function(response){
				if(response=="1"){
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('La ubicacion se ha registrado en la base de datos del sistema');
					if(action=='update'){
						_this.detalles($("#nueva-ubicaciones-id").val());
					}else{
						$("#ubicaciones-search-str").val($form.find("#nombre_cliente").val());
					}
					_this.cargarHTML(true,0);
					Custombox.close(); 
				}else{
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.error('&iexcl;Ha ocurrido un error! <br/> La accion NO se ha completado');
					Custombox.close(); 
				}
			}
		});
	}
	this.cargarJSON=function(reset,offset){
		if(this.scroll){
			this.scroll=false;
			this.loader($('#ubicaciones-lista-table tbody tr.tr-loader td:first'),'start');
			if(reset){
				$("#ubicaciones-lista-table").find("tr:not(.tr-loader)").remove();
			}
			jQuery.ajaxSetup({async:false});
			$.get(this.baseUrl+"productos/cargar_ubicaciones",{search:$('#ubicaciones-search-str').val(),offset:offset},function(ubicaciones){
				if(ubicaciones){
					$.each(ubicaciones,function(i,ubicacion){
						var clienteHtml="<tr id='ubicacion-"+ubicacion.id+"' data-clasificacion='"+ubicacion.clasificacion+"' data-credito='"+ubicacion.credito+"' data-dui='"+ubicacion.dui+"' data-nit='"+ubicacion.nit+"' data-nrc='"+ubicacion.nrc+"'><td><h4 class='noselecttext'>"+ubicacion.nombre+"</h4><small class='noselecttext'>"+ubicacion.razon+"</small></td><td class='contact-type noselecttext'><i class='fa fa-phone'></i></td><td class='noselecttext'> "+ubicacion.tel+"</td></tr>"
						$(clienteHtml).insertBefore('.tr-loader');
					});
				}else{
					toastr.options = {
					  "closeButton": true,
					  "positionClass": "toast-bottom-right"
					}
					toastr.warning('&iexcl;No se han encontrado más ubicaciones en la base de datos del sistema!');
				}
			},"json");
			this.loader($('#ubicaciones-lista-table tbody tr.tr-loader td:first'),'stop');
			this.scroll=true;
		}
	}
	this.cargarHTML=function(reset,offset){
		if(this.scroll){
			var _this =this;
			this.scroll=false;
			if(reset){
				$("#ubicaciones-lista-table").find("tr:not(.tr-loader)").remove();
			}
			$.get(this.baseUrl+"productos/cargarubicacioneshtml",{search:$('#ubicaciones-search-str').val(),offset:offset},function(ubicaciones){
				if(ubicaciones!=''){
					var html=$("#ubicaciones-lista-table > tbody").html()+ubicaciones;
					$("#ubicaciones-lista-table tbody").html(html);	
					if(reset){
						$("#ubicaciones-lista-table tbody tr:first").addClass("miracle-selected-table-item");
					}
					_this.scroll=true;
				}else{
					_this.scroll=true;
				}
			},"html");
		}
	}
	this.detalles=function(id){
		$("#ubicaciones-detalles-ajax-wrapper").html('');
		this.loader($('#ubicaciones-detalles-ajax-wrapper'),'start');
		$("#ubicaciones-detalles-info-wrapper").hide();
		$.get(this.baseUrl+"productos/detalles_ubicacion",{id:id},function(ubicacion){
			$("#ubicaciones-detalles-ajax-wrapper").html(ubicacion);
		},"html");
	}
	this.eliminar=function(id,nombre){
		var _this=this;
		swal({
		  title: "¿Eliminar "+nombre+"?",
		  text: "Esta acción eliminará definitivamente al ubicacion. ¿Esta seguro que desea continuar?",
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, Eliminar"
		},
		function(){
			$.get(_this.baseUrl+"productos/eliminar_ubicacion",{id:id},function(deleted){
				if(deleted){
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('La ubicacion <b>'+nombre+'</b> se ha eliminado.');
					$("#ubicaciones-detalles-ajax-wrapper").html('');
					$("#ubicaciones-detalles-info-wrapper").show();
					_this.cargarHTML(true,0);
				}
			},'text');
		});
	}
	this.loader=function($wrapper,action){
		if(action=='start'){
			$wrapper.show();
			var load=$(document.createElement('div')).attr('class','sk-spinner sk-spinner-fading-circle');
			for(var i=1; i<=12; i++){
				$(document.createElement('div')).attr('class','sk-circle'+i+' sk-circle').appendTo(load);
			}
			load.appendTo($wrapper);
		}else if('stop'){
			$wrapper.hide();
			$wrapper.find('.sk-spinner').remove();
		}
	}
}
var ubicaciones = new Ubicaciones();