var Ubicaciones=function(){
	this.baseUrl=null;
	this.scroll=true;
	this.test=function(){
		console.log('La clase Ubicaciones ha sido instanciado correctamente');
	}
	this.setUrl=function(url){
		this.baseUrl=url;
	}
	this.guardar=function(e,action){
		e.preventDefault();
		var $form=$(e.target);
		$form.find(":submit").prop('disabled', true);
		var _this=this;
		var clienteID=null;
		$form.ajaxSubmit({
			success:function(response){
				if(response=="1"){
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('La unidad se ha registrado en la base de datos del sistema');
					if(action=='update'){
						_this.detalles($("#nueva-unidades-id").val());
					}else{
						$("#unidades-search-str").val($form.find("#nombre_cliente").val());
					}
					_this.cargarHTML(true,0);
					Custombox.close(); 
				}else{
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.error('&iexcl;Ha ocurrido un error! <br/> La accion NO se ha completado');
					Custombox.close(); 
				}
			}
		});
	}
	this.cargarJSON=function(reset,offset){
		if(this.scroll){
			this.scroll=false;
			this.loader($('#unidades-lista-table tbody tr.tr-loader td:first'),'start');
			if(reset){
				$("#unidades-lista-table").find("tr:not(.tr-loader)").remove();
			}
			jQuery.ajaxSetup({async:false});
			$.get(this.baseUrl+"productos/cargar_unidades",{search:$('#unidades-search-str').val(),offset:offset},function(unidades){
				if(unidades){
					$.each(unidades,function(i,unidad){
						var clienteHtml="<tr id='unidad-"+unidad.id+"' data-clasificacion='"+unidad.clasificacion+"' data-credito='"+unidad.credito+"' data-dui='"+unidad.dui+"' data-nit='"+unidad.nit+"' data-nrc='"+unidad.nrc+"'><td><h4 class='noselecttext'>"+unidad.nombre+"</h4><small class='noselecttext'>"+unidad.razon+"</small></td><td class='contact-type noselecttext'><i class='fa fa-phone'></i></td><td class='noselecttext'> "+unidad.tel+"</td></tr>"
						$(clienteHtml).insertBefore('.tr-loader');
					});
				}else{
					toastr.options = {
					  "closeButton": true,
					  "positionClass": "toast-bottom-right"
					}
					toastr.warning('&iexcl;No se han encontrado más unidades en la base de datos del sistema!');
				}
			},"json");
			this.loader($('#unidades-lista-table tbody tr.tr-loader td:first'),'stop');
			this.scroll=true;
		}
	}
	this.cargarHTML=function(reset,offset){
		if(this.scroll){
			var _this =this;
			this.scroll=false;
			if(reset){
				$("#unidades-lista-table").find("tr:not(.tr-loader)").remove();
			}
			$.get(this.baseUrl+"productos/cargarunidadeshtml",{search:$('#unidades-search-str').val(),offset:offset},function(unidades){
				if(unidades!=''){
					var html=$("#unidades-lista-table > tbody").html()+unidades;
					$("#unidades-lista-table tbody").html(html);	
					if(reset){
						$("#unidades-lista-table tbody tr:first").addClass("miracle-selected-table-item");
					}
					_this.scroll=true;
				}else{
					_this.scroll=true;
				}
			},"html");
		}
	}
	this.detalles=function(id){
		$("#unidades-detalles-ajax-wrapper").html('');
		this.loader($('#unidades-detalles-ajax-wrapper'),'start');
		$("#unidades-detalles-info-wrapper").hide();
		$.get(this.baseUrl+"productos/detalles_unidad",{id:id},function(unidad){
			$("#unidades-detalles-ajax-wrapper").html(unidad);
		},"html");
	}
	this.eliminar=function(id,nombre){
		var _this=this;
		swal({
		  title: "¿Eliminar "+nombre+"?",
		  text: "Esta acción eliminará definitivamente la unidad. ¿Esta seguro que desea continuar?",
		  type: "warning",
		  showCancelButton: true,
		  confirmButtonColor: "#DD6B55",
		  cancelButtonText: "Cancelar",
		  confirmButtonText: "Si, Eliminar"
		},
		function(){
			$.get(_this.baseUrl+"productos/eliminar_unidad",{id:id},function(deleted){
				if(deleted){
					toastr.options = {
					  "closeButton": true,
					  "progressBar": true,
					  "positionClass": "toast-top-right"
					}
					toastr.success('La unidad <b>'+nombre+'</b> se ha eliminado.');
					$("#unidades-detalles-ajax-wrapper").html('');
					$("#unidades-detalles-info-wrapper").show();
					_this.cargarHTML(true,0);
				}
			},'text');
		});
	}
	this.loader=function($wrapper,action){
		if(action=='start'){
			$wrapper.show();
			var load=$(document.createElement('div')).attr('class','sk-spinner sk-spinner-fading-circle');
			for(var i=1; i<=12; i++){
				$(document.createElement('div')).attr('class','sk-circle'+i+' sk-circle').appendTo(load);
			}
			load.appendTo($wrapper);
		}else if('stop'){
			$wrapper.hide();
			$wrapper.find('.sk-spinner').remove();
		}
	}
}
var unidades = new Ubicaciones();